package net.mehvahdjukaar.moonlight.api.misc;

import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class ResourceLocationSearchTrie extends PathSearchTrie<class_2960> {

    // Insert a ResourceLocation (namespace + path) into the trie
    public void insert(class_2960 objectToAdd) {
        super.insert( getResPath(objectToAdd), objectToAdd);
    }

    public void insertPath(String fullPath){
        super.insert(fullPath, fromPath(fullPath));
    }

    public static @NotNull String getResPath(class_2960 objectToAdd) {
        String path = objectToAdd.method_12836() + "/" + objectToAdd.method_12832();
        path = getFolderPath(path);
        return path;
    }

    private static String getFolderPath(String path) {
        int lastIndex = path.lastIndexOf('/');

        // If there is no '/', return the original path (or empty if needed)
        if (lastIndex == -1) {
            return ""; // or return path if you want to keep single segment paths
        }

        return path.substring(0, lastIndex);
    }

    private static @NotNull class_2960 fromPath(@NotNull String folderPath) {
        int firstSlash = folderPath.indexOf('/');

        if (firstSlash == -1) {
            // No slash: treat whole string as namespace with empty path
            return  class_2960.method_60655(folderPath, "");
        }

        String namespace = folderPath.substring(0, firstSlash);
        String path = folderPath.substring(firstSlash + 1);
        return  class_2960.method_60655(namespace, path);
    }

    // Remove entries based on ResourceLocation
    public boolean remove(class_2960 object) {
        return super.remove(getResPath(object));
    }
}
