package net.mehvahdjukaar.moonlight.api.misc;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundSyncWorldDataMessage;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public abstract class WorldSavedData extends class_18 {

    @Override
    public final class_2487 method_75(class_2487 tag, class_7225.class_7874 registries) {
        var codec = (Codec) this.getType().getCodec();
        class_6903<class_2520> ops = registries.method_57093(class_2509.field_11560);
        var dataResult = codec.encode(this, ops, new class_2487());

        class_2487 inner = (class_2487) dataResult.getOrThrow();

        tag.method_10566(this.getType().getName(), inner);

        return tag;
    }

    @Override
    public void method_78(boolean dirty) {
        super.method_78(dirty);
    }

    //call when you want to sync to clients
    public void sync() {
        if (this.getType().isSyncable()) {
            NetworkHelper.sendToAllClientPlayers(new ClientBoundSyncWorldDataMessage<>(this));
        }
    }

    public abstract WorldSavedDataType<? extends WorldSavedData> getType();

    public void onReassigned(class_1937 level) {

    }
}
