package net.mehvahdjukaar.moonlight.api.misc;


import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;

//Basically a helper that manages syncing on world join and stores codecs cleanly
//per world, automatically synced when stream codec is not null. not per game. saved onto overworld level
public final class WorldSavedDataType<D extends WorldSavedData> {

    public static final Codec<WorldSavedDataType<? extends WorldSavedData>> CODEC =
            MoonlightRegistry.WORLD_SAVED_DATA_TYPE_REGISTRY.method_39673();
    public static final class_9139<class_9129, WorldSavedDataType<? extends WorldSavedData>> STREAM_CODEC =
            class_9135.method_56365(MoonlightRegistry.WORLD_SAVED_DATA_TYPE_REGISTRY.method_30517());


    private final Codec<D> codec;
    @Nullable
    private final class_9139<class_9129, D> streamCodec;
    private final class_18.class_8645<D> factory;
    private final String name;


    private D clientInstance = null;

    public WorldSavedDataType(class_2960 id, Function<class_3218, D> constructor, Codec<D> codec, @Nullable class_9139<class_9129, D> streamCodec) {
        this.codec = codec;
        this.streamCodec = streamCodec;
        this.name = id.method_36181();

        this.factory = new class_18.class_8645<>(() -> constructor.apply(
                PlatHelper.getCurrentServer().method_30002()),
                this::load, null);
    }

    public D getData(class_1937 level) {
        if (level.field_9236 && !this.isSyncable()) {
            throw new IllegalStateException("Tried to access unsyncable world saved data on client side!");
        }

        if (level instanceof class_3218 server) {
            return server.method_8503().method_30002().method_17983()
                    .method_17924(factory, name);
        } else {
            return clientInstance;
        }
    }

    public void setData(class_1937 level, D data) {
        if (level instanceof class_3218 server) {
            server.method_8503().method_30002().method_17983().method_123(name, data);
        } else {
            this.clientInstance = data;
        }
        data.onReassigned(level);
    }

    private D load(class_2487 tag, class_7225.class_7874 provider) {
        var t = tag.method_10580(this.getName());
        var ops = provider.method_57093(class_2509.field_11560);
        var dataResult = codec.decode(ops, t);
        return dataResult.getOrThrow().getFirst();
    }

    public Codec<D> getCodec() {
        return codec;
    }

    @Nullable
    public class_9139<class_9129, D> getStreamCodec() {
        return streamCodec;
    }

    public boolean isSyncable() {
        return streamCodec != null;
    }

    public String getName() {
        return name;
    }
}
