package net.mehvahdjukaar.moonlight.api.platform;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonElement;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.ItemRenderExtension;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.item.IItemDecoratorRenderer;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3302;
import net.minecraft.class_3611;
import net.minecraft.class_3665;
import net.minecraft.class_4002;
import net.minecraft.class_4730;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5614;
import net.minecraft.class_5617;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_5944;
import net.minecraft.class_707;
import net.minecraft.class_793;
import net.minecraft.client.resources.model.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * Helper class dedicated to platform independent client utility methods
 */
public class ClientHelper {

    @ExpectPlatform
    public static void addClientSetup(Runnable clientSetup) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void addClientSetupAsync(Runnable clientSetup) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void registerRenderType(class_2248 block, class_1921... types) {
        throw new AssertionError();
    }

    public static void registerRenderType(class_2248 block, class_1921 type) {
        registerRenderType(block, new class_1921[]{type});
    }

    @ExpectPlatform
    public static void registerFluidRenderType(class_3611 fluid, class_1921 type) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void addClientReloadListener(Supplier<class_3302> listener, class_2960 location) {
        throw new AssertionError();
    }

    @FunctionalInterface
    @Environment(EnvType.CLIENT)
    public interface ParticleFactory<T extends class_2394> {
        @NotNull class_707<T> create(class_4002 spriteSet);
    }

    @FunctionalInterface
    public interface ParticleEvent {
        <P extends class_2396<T>, T extends class_2394> void register(P particleType, ParticleFactory<T> factory);
    }

    @ExpectPlatform
    public static void addParticleRegistration(Consumer<ParticleEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface ItemDecoratorEvent {
        void register(class_1935 itemLike, IItemDecoratorRenderer renderer);
    }

    public interface ShaderEvent {
        void register(class_2960 id, class_293 vertexFormat, Consumer<class_5944> setter);
    }

    @ExpectPlatform
    public static void addShaderRegistration(Consumer<ShaderEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface ItemRendererEvent {
        default void register(class_1935 item, ItemStackRenderer renderer) {
            register(item, new ItemRenderExtension() {
                @Override
                public @Nullable ItemStackRenderer getItemRenderer() {
                    return renderer;
                }
            });
        }

        void register(class_1935 item, ItemRenderExtension extension);
    }

    @ExpectPlatform
    public static void addItemRenderersRegistration(Consumer<ItemRendererEvent> eventListener) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void addItemDecoratorsRegistration(Consumer<ItemDecoratorEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface EntityRendererEvent {
        <E extends class_1297> void register(class_1299<? extends E> entity, class_5617<E> renderer);
    }

    @ExpectPlatform
    public static void addEntityRenderersRegistration(Consumer<EntityRendererEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface BlockEntityRendererEvent {
        <E extends class_2586> void register(class_2591<? extends E> blockEntity, class_5614<E> renderer);
    }

    @ExpectPlatform
    public static void addBlockEntityRenderersRegistration(Consumer<BlockEntityRendererEvent> eventListener) {
        throw new AssertionError();
    }

    public interface BlockColorEvent {
        void register(class_322 color, class_2248... block);

        int getColor(class_2680 block, class_1920 level, class_2338 pos, int tint);

    }

    @ExpectPlatform
    public static void addBlockColorsRegistration(Consumer<BlockColorEvent> eventListener) {
        throw new AssertionError();
    }

    public interface ItemColorEvent {
        void register(class_326 color, class_1935... items);

        int getColor(class_1799 stack, int tint);

    }

    @ExpectPlatform
    public static void addItemColorsRegistration(Consumer<ItemColorEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface ModelLayerEvent {
        void register(class_5601 modelLayer, Supplier<class_5607> provider);
    }

    @ExpectPlatform
    public static void addModelLayerRegistration(Consumer<ModelLayerEvent> eventListener) {
        throw new AssertionError();
    }

    public interface SpecialModelEvent {
        void register(class_1091 modelLocation);

        void register(class_2960 id);
    }

    @ExpectPlatform
    public static void addSpecialModelRegistration(Consumer<SpecialModelEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface ModelLoaderEvent {
        void register(class_2960 id, CustomModelLoader loader);

        default void register(class_2960 id, Supplier<CustomBakedModel> bakedModelFactory) {
            register(id, (CustomModelLoader) (json, context) -> (modelBaker, spriteGetter, transform) -> bakedModelFactory.get());
        }

        default void register(class_2960 id, BiFunction<class_3665, Function<class_4730, class_1058>, CustomBakedModel> bakedModelFactory) {
            register(id, (CustomModelLoader) (json, context) -> (modelBaker, spriteGetter, transform) -> bakedModelFactory.apply(transform, spriteGetter));
        }
    }

    @ExpectPlatform
    public static void addModelLoaderRegistration(Consumer<ModelLoaderEvent> eventListener) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_1087 getModel(class_1092 modelManager, class_1091 modelLocation) {
        throw new AssertionError();
    }


    @FunctionalInterface
    public interface TooltipComponentEvent {
        <T extends class_5632> void register(Class<T> type, Function<? super T, ? extends class_5684> factory);
    }

    @ExpectPlatform
    public static void addTooltipComponentRegistration(Consumer<TooltipComponentEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface KeyBindEvent {
        void register(class_304 keyMapping);
    }

    @ExpectPlatform
    public static void addKeyBindRegistration(Consumer<KeyBindEvent> eventListener) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static int getPixelRGBA(class_1058 sprite, int frameIndex, int x, int y) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_793 parseBlockModel(JsonElement json) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static Path getModIcon(String modId) {
        throw new AssertionError();
    }

    /**
     * Pack in /resources/resourcepacks
     */
    @ExpectPlatform
    public static void registerOptionalTexturePack(class_2960 folderName, class_2561 displayName, boolean defaultEnabled) {
        throw new AssertionError();
    }

    public static void registerOptionalTexturePack(class_2960 folderName, boolean defaultEnabled) {
        registerOptionalTexturePack(folderName, class_2561.method_43470(LangBuilder.getReadableName(folderName.method_12832())), defaultEnabled);
    }


    private static final Cache<class_2960, class_4730> CACHED_MATERIALS = CacheBuilder.newBuilder()
            .expireAfterAccess(2, TimeUnit.MINUTES)
            .build();

    //cached materials
    public static class_4730 getBlockMaterial(class_2960 bockTexture) {
        try {
            return CACHED_MATERIALS.get(bockTexture, () -> new class_4730(class_1059.field_5275, bockTexture));
        } catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}