package net.mehvahdjukaar.moonlight.api.platform;

import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3302;
import net.minecraft.class_3908;
import net.minecraft.class_4174;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * Helper class dedicated to platform independent common utility methods that require a different implementation for each loader
 * Forge specific methods that dont have a fabric equivalent are located in ForgeHelper
 */
public class PlatHelper {

    @ExpectPlatform
    public static void addCommonSetup(Runnable commonSetup) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void addCommonSetupAsync(Runnable commonSetup) {
        throw new AssertionError();
    }

    /**
     * A setup step that runs similar to resource reloads. RegistryAccess and tags are available here as this runs on tag load
     * Boolean given is if this is run on the client logical side
     */
    @ExpectPlatform
    public static void addReloadableCommonSetup(BiConsumer<class_5455, Boolean> setup) {
        throw new AssertionError();
    }

    @Contract
    @ExpectPlatform
    public static boolean isDev() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isModLoadingValid() {
        throw new AssertionError();
    }

    /**
     * If loaders are during standard mod init phase
     */
    @ExpectPlatform
    public static boolean isInitializing() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean evaluateRecipeCondition(DynamicOps<JsonElement> ops, JsonElement jo) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <A> void setComponent(class_9322 to, class_9331<A> type, A componentValue) {
        throw new AssertionError();
    }

    @Contract
    @ExpectPlatform
    public static void invokeLevelUnload(class_1937 l) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isFakePlayer(class_3222 instance) {
        throw new AssertionError();
    }

    public enum Platform {
        FORGE, FABRIC;
        private static boolean quilt = false;

        static {
            try {
                Class.forName("org.quiltmc.loader.api.QuiltLoader");
                quilt = true;
            } catch (ClassNotFoundException ignored) {
            }
        }

        public boolean isForge() {
            return this == FORGE;
        }

        public boolean isFabric() {
            return this == FABRIC;
        }

        public boolean isQuilt() {
            return isFabric() && quilt;
        }

        public void ifForge(Runnable runnable) {
            if (isForge()) runnable.run();
        }

        public void ifFabric(Runnable runnable) {
            if (isFabric()) runnable.run();
        }
    }

    @Contract
    @ExpectPlatform
    public static Platform getPlatform() {
        throw new AssertionError();
    }

    public enum Side {
        CLIENT, SERVER;

        public boolean isClient() {
            return this == CLIENT;
        }

        public boolean isServer() {
            return this == SERVER;
        }

        public void ifClient(Runnable runnable) {
            if (isClient()) runnable.run();
        }

        public void ifServer(Runnable runnable) {
            if (isServer()) runnable.run();
        }
    }

    @Contract
    @ExpectPlatform
    public static Side getPhysicalSide() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static Path getGamePath() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static Path getModFilePath(String modId) {
        throw new AssertionError();
    }

    @Nullable
    @ExpectPlatform
    public static String getModPageUrl(String modId) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static String getModName(String modId) {
        throw new AssertionError();
    }

    @Nullable
    @ExpectPlatform
    public static <T> Field findField(Class<? super T> clazz, String fieldName) {
        throw new AssertionError();
    }

    @Nullable
    @ExpectPlatform
    public static Method findMethod(Class<?> clazz, String methodName, Class<?>... parameterTypes) {
        throw new AssertionError();
    }

    @Nullable
    @ExpectPlatform
    public static MinecraftServer getCurrentServer() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isModLoaded(String modId) {
        throw new AssertionError();
    }

    @Nullable
    @ExpectPlatform
    public static String getModVersion(String modId) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static List<String> getInstalledMods() {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static void registerResourcePack(class_3264 packType, Supplier<class_3288> packSupplier) {
        RegHelper.registerResourcePack(packType, packSupplier);
    }

    @Contract
    @ExpectPlatform
    public static boolean isMobGriefingOn(class_1937 level, class_1297 entity) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isAreaLoaded(class_4538 level, class_2338 pos, int maxRange) {
        throw new AssertionError();
    }

    @ExpectPlatform
    @Nullable
    public static class_4174 getFoodProperties(class_1799 stack, class_1657 player) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static int getBurnTime(class_1799 stack) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isFireSource(class_2680 blockState, class_1937 level, class_2338 pos, class_2350 up) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static int getFireSpreadSpeed(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static int getFlammability(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isFlammable(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void onCaughtFire(class_2680 state, class_1937 level, class_2338 pos, class_2350 direction, @Nullable class_1309 igniter) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_2596<class_2602> getEntitySpawnPacket(class_1297 entity, class_3231 serverEntity) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_1826 newSpawnEgg(Supplier<? extends class_1299<? extends class_1308>> entityType, int color, int outerColor, class_1792.class_1793 properties) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_2362 newFlowerPot(@Nullable Supplier<class_2362> emptyPot, Supplier<? extends class_2248> supplier, class_4970.class_2251 properties) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static class_2400 newParticle() {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T extends class_2394> class_2396<T> newParticle(MapCodec<T> codec, class_9139<class_9129, T> streamCodec) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T extends class_2586> class_2591<T> newBlockEntityType(BlockEntitySupplier<T> blockEntitySupplier, class_2248... validBlocks) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface BlockEntitySupplier<T extends class_2586> {
        @NotNull T create(class_2338 pos, class_2680 state);
    }

    @ExpectPlatform
    public static <E extends class_1297> class_1299<E> newEntityType(String name,
                                                                 class_1299.class_4049<E> factory, class_1311 category, float width, float height,
                                                                 int clientTrackingRange, boolean velocityUpdates, int updateInterval) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static void addServerReloadListener(class_3302 listener, class_2960 location) {
        addServerReloadListener(provider -> listener, location);
    }

    @ExpectPlatform
    public static void addServerReloadListener(Function<class_7225.class_7874, class_3302> listener, class_2960 location) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void openCustomMenu(class_3222 player, class_3908 menuProvider, Consumer<class_9129> extraDataProvider) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static void openCustomMenu(class_3222 player, class_3908 menuProvider, class_2338 pos) {
        openCustomMenu(player, menuProvider, buf -> buf.method_10807(pos));
    }

    public static <T extends class_1297 & class_3908> void openCustomMenu(class_3222 player, T menuProvider) {
        TileOrEntityTarget target = TileOrEntityTarget.of(menuProvider);
        openCustomMenu(player, menuProvider, target::write);
    }

    public static <T extends class_2586 & class_3908> void openCustomMenu(class_3222 player, T menuProvider) {
        TileOrEntityTarget target = TileOrEntityTarget.of(menuProvider);
        openCustomMenu(player, menuProvider, target::write);
    }

    @ExpectPlatform
    public static class_1657 getFakeServerPlayer(GameProfile id, class_3218 level) {
        throw new AssertionError();
    }

}
