package net.mehvahdjukaar.moonlight.api.platform;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.misc.*;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.SimplePackProvider;
import net.mehvahdjukaar.moonlight.api.trades.ItemListingManager;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.misc.AttachmentBuilderImpl;
import net.mehvahdjukaar.moonlight.core.pack.DynamicResourcesInternals;
import net.minecraft.class_117;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2482;
import net.minecraft.class_2540;
import net.minecraft.class_2544;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3853;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3962;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4558;
import net.minecraft.class_4970;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_6798;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_7157;
import net.minecraft.class_7706;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9168;
import net.minecraft.class_9283;
import net.minecraft.class_9331;
import net.minecraft.world.entity.*;
import net.minecraft.world.item.*;
import net.minecraft.world.item.crafting.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.*;

/**
 * Helper class dedicated to platform independent registration methods
 */
public class RegHelper {

    @ExpectPlatform
    public static <T, E extends T> RegSupplier<E> register(
            class_2960 name, Supplier<E> supplier, class_5321<? extends class_2378<T>> regKey) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T> void registerInBatch(class_2378<T> reg, Consumer<Registrator<T>> eventListener) {
        throw new AssertionError();
    }

    /**
     * Registers stuff immediately on fabric. Normal behavior for forge
     */
    @ExpectPlatform
    public static <T, E extends T> RegSupplier<E> registerAsync(class_2960 name, Supplier<E> supplier, class_5321<? extends class_2378<T>> regKey) {
        throw new AssertionError();
    }

    public static <T extends class_2248> RegSupplier<T> registerBlock(class_2960 name, Supplier<T> block) {
        return register(name, block, class_7924.field_41254);
    }

    //helpers
    public static <T extends class_2248> RegSupplier<T> registerBlockWithItem(class_2960 name, Supplier<T> blockFactory) {
        return registerBlockWithItem(name, blockFactory, new class_1792.class_1793());
    }

    public static <T extends class_2248> RegSupplier<T> registerBlockWithItem(class_2960 name, Supplier<T> blockFactory, class_1792.class_1793 properties) {
        RegSupplier<T> block = registerBlock(name, blockFactory);
        registerItem(name, () -> new class_1747(block.get(), properties));
        return block;
    }

    public static <T extends class_4558<?>> RegSupplier<T> registerTriggerType(class_2960 name, Supplier<T> instance) {
        return register(name, instance, class_7924.field_47498);
    }

    public static <T extends class_6798<?>> RegSupplier<T> registerPlacementModifier(class_2960 name, Supplier<T> instance) {
        return register(name, instance, class_7924.field_41211);
    }

    public static <T extends class_79> RegSupplier<class_5338> registerLootPoolEntry(class_2960 name,
                                                                                                          Supplier<MapCodec<T>> instance) {
        return register(name, () -> new class_5338(instance.get()), class_7924.field_41202);
    }

    public static <T extends class_5341> RegSupplier<class_5342> registerLootCondition(class_2960 name,
                                                                                                         Supplier<MapCodec<T>> instance) {
        return register(name, () -> new class_5342(instance.get()), class_7924.field_41198);
    }

    public static <T> Supplier<class_9331<T>> registerDataComponent(class_2960 name,
                                                                           Supplier<class_9331<T>> component) {
        return register(name, component, class_7924.field_49659);
    }

    @ExpectPlatform
    public static <T> Supplier<class_2941<T>> registerEntityDataSerializer(class_2960 name, Supplier<class_2941<T>> serializer) {
        throw new AssertionError();
    }

    public static RegSupplier<class_4158> registerPOI(class_2960 name, Supplier<class_4158> poi) {
        return register(name, poi, class_7924.field_41212);
    }

    public static RegSupplier<class_4158> registerPOI(class_2960 name, int searchDistance, int maxTickets, class_2248... blocks) {
        return registerPOI(name, () -> {
            ImmutableSet.Builder<class_2680> builder = ImmutableSet.builder();
            for (class_2248 block : blocks) {
                builder.addAll(block.method_9595().method_11662());
            }
            return new class_4158(builder.build(), searchDistance, maxTickets);
        });
    }

    public static RegSupplier<class_4158> registerPOI(class_2960 name, int searchDistance, int maxTickets, Supplier<class_2248>... blocks) {
        return registerPOI(name, () -> {
            ImmutableSet.Builder<class_2680> builder = ImmutableSet.builder();
            for (var block : blocks) {
                builder.addAll(block.get().method_9595().method_11662());
            }
            return new class_4158(builder.build(), searchDistance, maxTickets);
        });
    }

    //call in init when you have blocks
    @Deprecated(forRemoval = true)
    @ExpectPlatform
    /// USE {@link RegHelper#addExtraPOIStatesRegistration(Consumer)} and it must be called in Init, not Setup
    public static void addBlocksToPOI(class_5321<class_4158> poi, Iterable<? extends class_2248> blocks) {
        throw new AssertionError();
    }

    public interface ExtraPOIStatesEvent {

        @Deprecated(forRemoval = true)
        default void addStatesToPoi(class_5321<class_4158> typeKey, Set<class_2680> states) {
            addStates(typeKey, states);
        }

        @Deprecated(forRemoval = true)
        default void addBlockToPoi(class_5321<class_4158> typeKey, class_2248 block) {
            addBlock(typeKey, block);
        }

        void addBlock(class_5321<class_4158> typeKey, class_2248 block);

        void addStates(class_5321<class_4158> typeKey, Set<class_2680> states);

        default void addBlocks(class_5321<class_4158> typeKey, Collection<class_2248> blocks) {
            for (class_2248 b : blocks) {
                addBlock(typeKey, b);
            }
        }
    }

    @ExpectPlatform
    public static void addExtraPOIStatesRegistration(Consumer<RegHelper.ExtraPOIStatesEvent> eventListener) {
        throw new AssertionError();
    }

    public interface ExtraBEStatesEvent {

        void addBlocks(class_2591<?> typeKey, class_2248... block);
    }

    @ExpectPlatform
    public static void addExtraBEBlockStatesRegistration(Consumer<RegHelper.ExtraBEStatesEvent> eventListener) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T extends class_3611> RegSupplier<T> registerFluid(class_2960 name, Supplier<T> fluid) {
        throw new AssertionError();
    }

    public static <T extends class_1792> RegSupplier<T> registerItem(class_2960 name, Supplier<T> item) {
        return register(name, item, class_7924.field_41197);
    }

    public static <T extends class_3031<?>> RegSupplier<T> registerFeature(class_2960 name, Supplier<T> feature) {
        return register(name, feature, class_7924.field_41267);
    }

    public static <T extends class_7151<?>> RegSupplier<T> registerStructure(class_2960 name, Supplier<T> feature) {
        //TODO: this causes issues on fabric and its very random as might be on only with some random unrelated mods. best to lave it like this
        // return register(name, feature, Registry.STRUCTURE_TYPES);
        return registerAsync(name, feature, class_7924.field_41231);
    }


    public static <T extends class_3414> RegSupplier<T> registerSound(class_2960 name, Supplier<T> sound) {
        return register(name, sound, class_7924.field_41225);
    }

    public static RegSupplier<class_3414> registerSound(class_2960 name) {
        return registerSound(name, () -> class_3414.method_47908(name));
    }

    public static RegSupplier<class_3414> registerSound(class_2960 name, float fixedRange) {
        return registerSound(name, () -> class_3414.method_47909(name, fixedRange));
    }

    @ExpectPlatform
    public static <C extends class_1703> RegSupplier<class_3917<C>> registerMenuType(
            class_2960 name,
            TriFunction<Integer, class_1661, class_2540, C> containerFactory) {
        throw new AssertionError();
    }

    public static <T extends class_1291> RegSupplier<T> registerEffect(class_2960 name, Supplier<T> effect) {
        return register(name, effect, class_7924.field_41208);
    }

    public static <T extends class_1887> RegSupplier<T> registerEnchantment(class_2960 name, Supplier<T> enchantment) {
        return register(name, enchantment, class_7924.field_41265);
    }

    public static <T extends class_4149<? extends class_4148<?>>> RegSupplier<T> registerSensor(class_2960 name, Supplier<T> sensorType) {
        return register(name, sensorType, class_7924.field_41221);
    }

    public static <T extends class_4148<?>> RegSupplier<class_4149<T>> registerSensorI(class_2960 name, Supplier<T> sensor) {
        return register(name, () -> new class_4149<>(sensor), class_7924.field_41221);
    }

    public static <T extends class_4168> RegSupplier<T> registerActivity(class_2960 name, Supplier<T> activity) {
        return register(name, activity, class_7924.field_41222);
    }

    public static RegSupplier<class_4168> registerActivity(class_2960 name) {
        return registerActivity(name, () -> new class_4168(name.method_12832()));
    }

    public static <T extends class_4170> RegSupplier<T> registerSchedule(class_2960 name, Supplier<T> schedule) {
        return register(name, schedule, class_7924.field_41220);
    }

    public static <T extends class_4140<?>> RegSupplier<T> registerMemoryModule(class_2960 name, Supplier<T> memory) {
        return register(name, memory, class_7924.field_41206);
    }

    public static <U> RegSupplier<class_4140<U>> registerMemoryModule(class_2960 name, @Nullable Codec<U> codec) {
        return register(name, () -> new class_4140<>(Optional.ofNullable(codec)), class_7924.field_41206);
    }

    public static <T extends class_1865<?>> RegSupplier<T> registerRecipeSerializer(class_2960 name, Supplier<T> recipe) {
        return register(name, recipe, class_7924.field_41216);
    }

    @ExpectPlatform
    public static <T extends class_3955> RegSupplier<class_1865<T>> registerSpecialRecipe(class_2960 name, class_1866.class_7711<T> factory) {
        throw new AssertionError();
    }

    public static <T extends class_1860<?>> Supplier<class_3956<T>> registerRecipeType(class_2960 name) {
        return RegHelper.register(name, () -> {
            String id = name.toString();
            return new class_3956<T>() {
                @Override
                public String toString() {
                    return id;
                }
            };
        }, class_7924.field_41217);
    }


    public static <T extends class_2591<E>, E extends class_2586> RegSupplier<T> registerBlockEntityType(class_2960 name,
                                                                                                               Supplier<T> blockEntity) {
        return register(name, blockEntity, class_7924.field_41255);
    }

    public static <E extends class_2586> RegSupplier<class_2591<E>> registerBlockEntityType(
            class_2960 name, BiFunction<class_2338, class_2680, E> blockEntitySupplier, class_2248... blocks) {
        return registerBlockEntityType(name, () -> PlatHelper.newBlockEntityType(blockEntitySupplier::apply, blocks));
    }

    @SafeVarargs
    public static <E extends class_2586> RegSupplier<class_2591<E>> registerBlockEntityType(
            class_2960 name, BiFunction<class_2338, class_2680, E> blockEntitySupplier, Supplier<class_2248>... blocks) {
        return registerBlockEntityType(name, () -> PlatHelper.newBlockEntityType(blockEntitySupplier::apply,
                Arrays.stream(blocks).map(Supplier::get).toArray(class_2248[]::new)));
    }

    public static RegSupplier<class_2400> registerParticle(class_2960 name) {
        return register(name, PlatHelper::newParticle, class_7924.field_41210);
    }

    public static <A> class_2378<A> registerRegistry(class_2960 key, boolean synced) {
        return registerRegistry(class_5321.method_29180(key), synced);
    }

    @ExpectPlatform
    public static <A> class_2378<A> registerRegistry(class_5321<class_2378<A>> key, boolean synced) {
        throw new AssertionError();
    }

    //give null network codec for no syncing
    public static <A extends WorldSavedData> WorldSavedDataType<A> registerWorldSavedData(
            class_2960 key, Function<class_3218, A> constructor,
            Codec<A> codec, @Nullable class_9139<class_9129, A> networkCodec) {
        WorldSavedDataType<A> instance = new WorldSavedDataType<>(key, constructor, codec, networkCodec);
        register(key, () -> instance, MoonlightRegistry.WORLD_SAVED_DATA_TYPE_REGISTRY.method_30517());
        return instance;
    }

    public static <T extends class_2394> RegSupplier<class_2396<T>> registerParticle(
            class_2960 name, MapCodec<T> codec, class_9139<class_9129, T> streamCodec) {
        return register(name, () -> PlatHelper.newParticle(codec, streamCodec), class_7924.field_41210);
    }

    public static <T extends class_117> RegSupplier<class_5339<T>> registerLootFunction(
            class_2960 name, MapCodec<T> codec) {
        return register(name, () -> new class_5339<>(codec), class_7924.field_41199);
    }

    //TODO: change to supplier
    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, class_1299.class_1300<T> builder) {
        return register(name, () -> builder.method_5905(name.method_12832()), class_7924.field_41266);
    }

    @Deprecated(forRemoval = true)
    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, Supplier<class_1299<T>> type) {
        return register(name, type, class_7924.field_41266);
    }


    @Deprecated(forRemoval = true)
    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, class_1299.class_4049<T> factory,
                                                                                   class_1311 category, float width, float height) {
        return registerEntityType(name, factory, category, width, height, 5);
    }

    //not needed?
    @Deprecated(forRemoval = true)
    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, class_1299.class_4049<T> factory,
                                                                                   class_1311 category, float width,
                                                                                   float height, int clientTrackingRange) {
        return registerEntityType(name, factory, category, width, height, clientTrackingRange, 3);
    }


    @Deprecated(forRemoval = true)
    @ExpectPlatform
    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, class_1299.class_4049<T> factory,
                                                                                   class_1311 category, float width, float height,
                                                                                   int clientTrackingRange, int updateInterval) {
        throw new AssertionError();
    }

    public static RegSupplier<class_1741> registerArmorMaterial(class_2960 name, int totalDefense, Supplier<class_1856> ingredient,
                                                                   int enchValue, Supplier<class_6880<class_3414>> sound,
                                                                   float toughness, float knockbackResistance) {
        return register(name, () -> new class_1741(calculateStandardDefence(totalDefense), enchValue, sound.get(), ingredient,
                List.of(new class_1741.class_9196(name)), toughness, knockbackResistance), class_7924.field_48977);
    }

    private static EnumMap<class_1738.class_8051, Integer> calculateStandardDefence(int totalDefense) {
        EnumMap<class_1738.class_8051, Integer> defenseMap = new EnumMap<>(class_1738.class_8051.class);

        // Proportions for each armor piece using a Map
        Map<class_1738.class_8051, Double> proportions = new LinkedHashMap<>();
        proportions.put(class_1738.class_8051.field_41935, 0.41);
        proportions.put(class_1738.class_8051.field_41936, 0.32);
        proportions.put(class_1738.class_8051.field_41934, 0.14);
        proportions.put(class_1738.class_8051.field_41937, 0.13);

        // Calculate initial (rounded down) values for each piece
        for (Map.Entry<class_1738.class_8051, Double> entry : proportions.entrySet()) {
            class_1738.class_8051 type = entry.getKey();
            int defenseValue = (int) (entry.getValue() * totalDefense);
            defenseMap.put(type, defenseValue);
        }

        // Calculate the remainder to distribute
        int remainder = totalDefense - defenseMap.values().stream().mapToInt(Integer::intValue).sum();

        // Distribute the remainder to pieces with room to grow
        while (remainder > 0) {
            for (Map.Entry<class_1738.class_8051, Double> entry : proportions.entrySet()) {
                class_1738.class_8051 type = entry.getKey();
                int maxDefense = (int) Math.ceil(entry.getValue() * totalDefense);
                int currentDefense = defenseMap.get(type);
                if (currentDefense < maxDefense) {
                    defenseMap.put(type, currentDefense + 1);
                    remainder--;
                    if (remainder <= 0) break; // Exit if no remainder left
                }
            }
        }
        defenseMap.put(class_1738.class_8051.field_48838,
                defenseMap.get(class_1738.class_8051.field_41935) + defenseMap.get(class_1738.class_8051.field_41937));
        return defenseMap;
    }


    @Deprecated(forRemoval = true)
    public static void registerCompostable(class_1935 itemLike, float chance) {
        class_3962.field_17566.put(itemLike.method_8389(), chance);
    }

    @Deprecated(forRemoval = true)
    @ExpectPlatform //fabric
    public static void registerItemBurnTime(class_1792 item, int burnTime) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void registerBlockFlammability(class_2248 item, int igniteOdds, int burnOdds) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void registerSimpleRecipeCondition(class_2960 id, Predicate<String> predicate) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T> void registerDataPackRegistry(class_5321<class_2378<T>> registryKey, Codec<T> codec, @Nullable Codec<T> networkCodec) {
        throw new AssertionError();
    }

    public static <T> class_5321<class_2378<T>> registerDataPackRegistry(class_2960 id, Codec<T> codec, @Nullable Codec<T> networkCodec) {
        class_5321<class_2378<T>> key = class_5321.method_29180(id);
        registerDataPackRegistry(key, codec, networkCodec);
        return key;
    }

    @ExpectPlatform
    public static RegSupplier<class_1761> registerCreativeModeTab(
            class_2960 name,
            boolean searchBar,
            List<class_2960> afterTabs, List<class_2960> beforeTabs, Consumer<class_1761.class_7913> configurator
    ) {
        throw new AssertionError();
    }

    private static final List<class_2960> DEFAULT_AFTER_ENTRIES = java.util.List.of(class_7706.field_40205.method_29177());

    public static RegSupplier<class_1761> registerCreativeModeTab(class_2960 name, Consumer<class_1761.class_7913> configurator) {
        return registerCreativeModeTab(name, false, configurator);
    }

    public static RegSupplier<class_1761> registerCreativeModeTab(class_2960 name, boolean searchBar, Consumer<class_1761.class_7913> configurator) {
        return registerCreativeModeTab(name, searchBar, DEFAULT_AFTER_ENTRIES, List.of(), configurator);
    }

    @ExpectPlatform
    public static void addItemsToTabsRegistration(Consumer<ItemToTabEvent> event) {
        throw new AssertionError();
    }


    public interface ItemToTabEvent {

        class_1761.class_8128 getParameters();

        void addItems(class_5321<class_1761> tab, @Nullable Predicate<class_1799> target, boolean after, List<class_1799> items);

        default void add(class_5321<class_1761> tab, class_1935... items) {
            addAfter(tab, null, items);
        }

        default void add(class_5321<class_1761> tab, class_1799... items) {
            addAfter(tab, null, items);
        }

        default void addAfter(class_5321<class_1761> tab, Predicate<class_1799> target, class_1935... items) {
            List<class_1799> stacks = new ArrayList<>();

            for (var i : items) {
                if (i.method_8389().method_7854().method_7960()) {
                    throw new IllegalStateException("Attempted to add empty item " + i + " to item tabs. It's likely that some mod tried to call asItem before items were registered\");");
                } else stacks.add(i.method_8389().method_7854());
            }
            addItems(tab, target, true, stacks);
        }

        default void addAfter(class_5321<class_1761> tab, Predicate<class_1799> target, class_1799... items) {
            addItems(tab, target, true, java.util.List.of(items));
        }

        default void addBefore(class_5321<class_1761> tab, Predicate<class_1799> target, class_1935... items) {
            List<class_1799> stacks = new ArrayList<>();
            for (var i : items) {
                if (i.method_8389().method_7854().method_7960()) {
                    throw new IllegalStateException("Attempted to add empty item " + i + " to item tabs. It's likely that some mod tried to call asItem before items were registered");
                } else stacks.add(i.method_8389().method_7854());
            }
            addItems(tab, target, false, stacks);
        }

        default void addBefore(class_5321<class_1761> tab, Predicate<class_1799> target, class_1799... items) {
            addItems(tab, target, false, java.util.List.of(items));
        }

    }

    @FunctionalInterface
    public interface AttributeEvent {
        void register(class_1299<? extends class_1309> type, class_5132.class_5133 builder);
    }

    @ExpectPlatform
    public static void addAttributeRegistration(Consumer<AttributeEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface SpawnPlacementEvent {
        <T extends class_1308> void register(class_1299<T> entityType, class_9168 decoratorType,
                                      class_2902.class_2903 heightMapType, class_1317.class_4306<T> decoratorPredicate);
    }

    @ExpectPlatform
    public static void addSpawnPlacementsRegistration(Consumer<SpawnPlacementEvent> eventListener) {
        throw new AssertionError();
    }

    @FunctionalInterface
    public interface CommandRegistration {
        void accept(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection);
    }

    @ExpectPlatform
    public static void addCommandRegistration(CommandRegistration eventListener) {
        throw new AssertionError();
    }

    public enum VariantType {
        BLOCK(class_2248::new),
        STAIRS(ModStairBlock::new),
        SLAB(class_2482::new),
        WALL(class_2544::new);
        private final BiFunction<Supplier<class_2248>, class_4970.class_2251, class_2248> constructor;

        VariantType(BiFunction<Supplier<class_2248>, class_4970.class_2251, class_2248> constructor) {
            this.constructor = constructor;
        }

        VariantType(Function<class_4970.class_2251, class_2248> constructor) {
            this.constructor = (b, p) -> constructor.apply(p);
        }

        public class_2248 create(class_4970.class_2251 properties, @Nullable Supplier<class_2248> parent) {
            return this.constructor.apply(parent, properties);
        }

        public static void addToTab(ItemToTabEvent event, Map<VariantType, Supplier<class_2248>> blocks) {
            Map<VariantType, Supplier<class_2248>> m = new EnumMap<>(blocks);
            event.add(class_7706.field_40195, m.values().stream().map(Supplier::get).toArray(class_2248[]::new));
        }

    }

    public static EnumMap<VariantType, Supplier<class_2248>> registerBaseBlockSet(class_2960 baseName, class_2248 parentBlock) {
        return registerBaseBlockSet(baseName, class_4970.class_2251.method_9630(parentBlock));
    }

    /**
     * Registers block, slab and vertical slab
     */
    public static EnumMap<VariantType, Supplier<class_2248>> registerBaseBlockSet(
            class_2960 baseName, class_4970.class_2251 properties) {
        return registerBlockSet(new VariantType[]{VariantType.BLOCK, VariantType.SLAB}, baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<class_2248>> registerReducedBlockSet(class_2960 baseName, class_2248 parentBlock) {
        return registerReducedBlockSet(baseName, class_4970.class_2251.method_9630(parentBlock));
    }

    /**
     * Registers block, slab stairs and vertical slab
     */
    public static EnumMap<VariantType, Supplier<class_2248>> registerReducedBlockSet(
            class_2960 baseName, class_4970.class_2251 properties) {
        return registerBlockSet(new VariantType[]{VariantType.BLOCK, VariantType.STAIRS, VariantType.SLAB}, baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<class_2248>> registerFullBlockSet(class_2960 baseName,
                                                                             class_2248 parentBlock) {
        return registerFullBlockSet(baseName, class_4970.class_2251.method_9630(parentBlock));
    }

    /**
     * Utility to register a full block set
     *
     * @return registry object map
     */
    public static EnumMap<VariantType, Supplier<class_2248>> registerFullBlockSet(
            class_2960 baseName, class_4970.class_2251 properties) {
        return registerBlockSet(VariantType.values(), baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<class_2248>> registerBlockSet(
            VariantType[] types, class_2960 baseName, class_4970.class_2251 properties) {

        if (!new ArrayList<>(List.of(types)).contains(VariantType.BLOCK))
            throw new IllegalStateException("Must contain base variant type");

        var block = registerBlock(baseName, () -> VariantType.BLOCK.create(properties, null));
        registerItem(baseName, () -> new class_1747(block.get(), (new class_1792.class_1793())));

        var m = registerBlockSet(types, block, baseName.method_12836());
        m.put(VariantType.BLOCK, block);
        return m;
    }

    public static EnumMap<VariantType, Supplier<class_2248>> registerBlockSet(
            VariantType[] types, RegSupplier<? extends class_2248> baseBlock, String modId) {

        class_2960 baseName = baseBlock.getId();
        EnumMap<VariantType, Supplier<class_2248>> map = new EnumMap<>(VariantType.class);
        for (VariantType type : types) {
            if (type.equals(VariantType.BLOCK)) continue;
            String name = baseName.method_12832();
            name += "_" + type.name().toLowerCase(Locale.ROOT);
            class_2960 blockId = class_2960.method_60655(modId, name);
            var block = registerBlock(blockId, () ->
                    type.create(class_4970.class_2251.method_9630(baseBlock.get()), baseBlock::get));
            registerItem(blockId, () -> new class_1747(block.get(), new class_1792.class_1793()));
            map.put(type, block);
        }
        return map;
    }

    public interface LootInjectEvent {
        class_2960 getTable();

        void addTableReference(class_2960 targetId);
    }

    /**
     * This uses fabric loot modify event and something equivalent to the old forge loot modift event.
     * It simply adds a loot table reference pool to the target table
     *
     * @param eventListener function that takes in the original table id and spits out the table reference id. Return null for no op
     */
    @ExpectPlatform
    public static void addLootTableInjects(Consumer<LootInjectEvent> eventListener) {
        throw new AssertionError();
    }

    // Only relevant on forge
    @ExpectPlatform
    public static void registerFireworkRecipe(class_9283.class_1782 shape, class_1792 ingredient) {
        throw new AssertionError();
    }

    /**
     * Very hack solution for forge. Call this as soon as your mod is created in its constructor, offering your mod bus
     */
    @ExpectPlatform
    public static void startRegisteringFor(Object bus) {
        throw new AssertionError();
    }

    public static void addDynamicDispenserBehaviorRegistration(Consumer<DispenserHelper.Event> eventListener) {
        DispenserHelper.addListener(eventListener, DispenserHelper.Priority.NORMAL);
    }

    public static void addDynamicDispenserBehaviorRegistration(Consumer<DispenserHelper.Event> eventListener, DispenserHelper.Priority priority) {
        DispenserHelper.addListener(eventListener, priority);
    }

    /**
     * Call on mod setup. Register a new serializer for your trade
     */
    public static void registerDynamicItemListingSerializer(class_2960 id, MapCodec<? extends ModItemListing> trade) {
        ItemListingManager.registerSerializer(id, trade);
    }

    /**
     * Registers a simple special trade
     */
    public static void registerDynamicItemListingSerializer(class_2960 id, class_3853.class_1652 instance, int level) {
        ItemListingManager.registerSimple(id, instance, level);
    }

    @ExpectPlatform
    public static void registerResourcePack(class_3264 packType, Supplier<class_3288> packSupplier) {
        throw new AssertionError();
    }

    public static void registerDynamicResourceProvider(DynamicResourcesProvider provider) {
        DynamicResourcesInternals.registerProvider(provider);
        SimplePackProvider packSupplier = provider;

        class_3264 packType = provider.getPackType();
        if (packType == class_3264.field_14188) {
            SimplePackProvider maybeMerged = MoonlightClient.mergePackSupplier(provider);
            if (maybeMerged == null) return; //merged, no need to register
            else packSupplier = maybeMerged;
        }
        registerResourcePack(packType, packSupplier::createPack);
    }


    @ApiStatus.NonExtendable
    public interface AttachmentBuilder<A> {

        static <A> AttachmentBuilder<A> create(Supplier<A> initializer) {
            return new AttachmentBuilderImpl<>(initializer);
        }

        /**
         * Declares that attachments should persist between server restarts, using the provided {@link Codec} for
         * (de)serialization.
         *
         * @param codec the codec used for (de)serialization
         * @return the builder
         */
        AttachmentBuilder<A> persistent(Codec<A> codec);

        /**
         * Declares that when a player dies and respawns, the attachments of this type should remain.
         *
         * @return the builder
         */
        AttachmentBuilder<A> copyOnDeath();

        /**
         * Sets the default initializer for this attachment type.
         *
         * <p>It is <i>encouraged</i> for {@link A} to be an immutable data type, such as a primitive type
         * or an immutable record.</p>
         *
         * <p>Otherwise, it is important to ensure that attachments <i>do not share any mutable state</i>.
         * As an example, for a (mutable) list/array attachment type,
         * the initializer should create a new independent instance each time it is called.</p>
         *
         * @param initializer the initializer
         * @return the builder
         */

        /**
         * Declares that this attachment type may be automatically synchronized with some clients, as determined by {@code syncPredicate}.
         *
         * @param packetCodec   the codec used to serialize the attachment data over the network
         * @param syncPredicate an {@link BiPredicate} determining with which clients to synchronize data
         * @return the builder
         */
        AttachmentBuilder<A> syncWith(class_9139<? super class_9129, A> packetCodec, BiPredicate<Object, class_3222> syncPredicate);

        default AttachmentBuilder<A> syncWith(class_9139<? super class_9129, A> packetCodec) {
            return syncWith(packetCodec, (provider, player) -> true);
        }
    }

    @ExpectPlatform
    public static <A, T> IAttachmentType<A, T> registerDataAttachment(class_2960 id,
                                                                   Supplier<AttachmentBuilder<A>> config,
                                                                   Class<T> targetClass) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static <A> IAttachmentType<A, Object> regDataAttachment(class_2960 id, Supplier<AttachmentBuilder<A>> config) {
        return registerDataAttachment(id, config, Object.class);
    }

}



