package net.mehvahdjukaar.moonlight.api.platform.fabric;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.*;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.client.model.fabric.MLFabricModelLoaderRegistry;
import net.mehvahdjukaar.moonlight.api.item.IItemDecoratorRenderer;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.fabric.ITextureAtlasSpriteExtension;
import net.mehvahdjukaar.moonlight.fabric.MoonlightFabricClient;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_5616;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_793;
import java.io.IOException;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ClientHelperImpl {

    public static void registerRenderType(class_2248 block, class_1921... type) {
        BlockRenderLayerMap.INSTANCE.putBlock(block, type[0]);
    }

    public static void addParticleRegistration(Consumer<ClientHelper.ParticleEvent> eventListener) {
        Moonlight.assertInitPhase();
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept(ClientHelperImpl::registerParticle);
        });
    }

    private static <P extends class_2396<T>, T extends class_2394> void registerParticle(P type, ClientHelper.ParticleFactory<T> registration) {
        ParticleFactoryRegistry.getInstance().register(type, registration::create);
    }

    public static void addEntityRenderersRegistration(Consumer<ClientHelper.EntityRendererEvent> eventListener) {
        Moonlight.assertInitPhase();

        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept(EntityRendererRegistry::register);
        });
    }

    public static void addBlockEntityRenderersRegistration(Consumer<ClientHelper.BlockEntityRendererEvent> eventListener) {
        Moonlight.assertInitPhase();

        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept(class_5616::method_32144);
        });
    }

    public static void addBlockColorsRegistration(Consumer<ClientHelper.BlockColorEvent> eventListener) {
        Moonlight.assertInitPhase();

        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept(new ClientHelper.BlockColorEvent() {
                @Override
                public void register(class_322 color, class_2248... block) {
                    ColorProviderRegistry.BLOCK.register(color, block);
                }

                @Override
                public int getColor(class_2680 block, class_1920 level, class_2338 pos, int tint) {
                    var c = ColorProviderRegistry.BLOCK.get(block.method_26204());
                    return c == null ? -1 : c.getColor(block, level, pos, tint);
                }
            });
        });
    }

    public static void addItemColorsRegistration(Consumer<ClientHelper.ItemColorEvent> eventListener) {
        Moonlight.assertInitPhase();

        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept(new ClientHelper.ItemColorEvent() {
                @Override
                public void register(class_326 color, class_1935... items) {
                    ColorProviderRegistry.ITEM.register(color, items);
                }

                @Override
                public int getColor(class_1799 stack, int tint) {
                    var c = ColorProviderRegistry.ITEM.get(stack.method_7909());
                    return c == null ? -1 : c.getColor(stack, tint);
                }
            });
        });
    }

    public static void addClientReloadListener(Supplier<class_3302> listener, class_2960 name) {
        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(
                new ReloadWrapper(listener, name));
    }

    private static final class ReloadWrapper implements IdentifiableResourceReloadListener, class_3302 {
        private final Supplier<class_3302> inner;
        private final class_2960 getFabricId;

        private ReloadWrapper(Supplier<class_3302> listenerSupplier,
                              class_2960 getFabricId) {
            this.inner = Suppliers.memoize(listenerSupplier::get);
            this.getFabricId = getFabricId;
        }

        @Override
        public CompletableFuture<Void> method_25931(class_4045 preparationBarrier, class_3300 resourceManager,
                                              class_3695 preparationsProfiler, class_3695 reloadProfiler,
                                              Executor backgroundExecutor, Executor gameExecutor) {
            return inner.get().method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
        }

        @Override
        public class_2960 getFabricId() {
            return getFabricId;
        }
    }

    public static final Map<class_1935, IItemDecoratorRenderer> ITEM_DECORATORS = new IdentityHashMap<>();

    public static void addItemDecoratorsRegistration(Consumer<ClientHelper.ItemDecoratorEvent> eventListener) {
        Moonlight.assertInitPhase();

        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept(ITEM_DECORATORS::put);
        });
    }


    public static void addModelLayerRegistration(Consumer<ClientHelper.ModelLayerEvent> eventListener) {
        Moonlight.assertInitPhase();

        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept((a, b) -> EntityModelLayerRegistry.registerModelLayer(a, b::get));
        });
    }

    public static void addSpecialModelRegistration(Consumer<ClientHelper.SpecialModelEvent> eventListener) {
        Moonlight.assertInitPhase();
        ModelLoadingPlugin.register(pluginContext -> {
            eventListener.accept(new ClientHelper.SpecialModelEvent() {
                @Override
                public void register(class_1091 modelLocation) {
                    pluginContext.addModels(modelLocation.comp_2875());
                }

                @Override
                public void register(class_2960 id) {
                    pluginContext.addModels(id);
                }
            });
        });
    }

    public static void addTooltipComponentRegistration(Consumer<ClientHelper.TooltipComponentEvent> eventListener) {
        Moonlight.assertInitPhase();

        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept(ClientHelperImpl::tooltipReg);
        });
    }

    private static <T extends class_5632> void tooltipReg(Class<T> tClass, Function<? super T, ? extends class_5684> factory) {
        TooltipComponentCallback.EVENT.register(data -> tClass.isAssignableFrom(data.getClass()) ? factory.apply((T) data) : null);
    }


    public static void addModelLoaderRegistration(Consumer<ClientHelper.ModelLoaderEvent> eventListener) {
        Moonlight.assertInitPhase();

        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept(MLFabricModelLoaderRegistry::registerLoader);
        });
    }

    public static void addKeyBindRegistration(Consumer<ClientHelper.KeyBindEvent> eventListener) {
        Moonlight.assertInitPhase();

        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept(KeyBindingHelper::registerKeyBinding);
        });
    }


    public static int getPixelRGBA(class_1058 sprite, int frameIndex, int x, int y) {
        return ((ITextureAtlasSpriteExtension) sprite).getPixelRGBA(frameIndex, x, y);
    }

    public static class_1087 getModel(class_1092 modelManager, class_1091 modelLocation) {
        return modelManager.getModel(modelLocation.comp_2875());
    }


    public static Path getModIcon(String modId) {
        var container = FabricLoader.getInstance().getModContainer(modId).get();
        return container.getMetadata().getIconPath(512).flatMap(container::findPath).orElse(null);
    }

    public static class_793 parseBlockModel(JsonElement json) {
        return class_793.method_3430(json.toString()); //sub optimal... too bad
    }

    public static void addClientSetup(Runnable clientSetup) {
        Moonlight.assertInitPhase();

        MoonlightFabricClient.CLIENT_SETUP_WORK.add(clientSetup);
    }


    public static void addClientSetupAsync(Runnable clientSetup) {
        addClientSetup(clientSetup);
    }


    public static void registerFluidRenderType(class_3611 fluid, class_1921 type) {
        BlockRenderLayerMap.INSTANCE.putFluid(fluid, type);
    }

    public static void registerOptionalTexturePack(class_2960 folderName, class_2561 displayName, boolean defaultEnabled) {
        Moonlight.assertInitPhase();
        if (!PlatHelper.isDev()) {
            FabricLoader.getInstance().getModContainer(folderName.method_12836()).ifPresent(c -> {
                ResourceManagerHelper.registerBuiltinResourcePack(folderName, c, displayName,
                        defaultEnabled ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL);
            });
        }
    }

    public static void addShaderRegistration(Consumer<ClientHelper.ShaderEvent> eventListener) {
        Moonlight.assertInitPhase();
        CoreShaderRegistrationCallback.EVENT.register(ev -> {
            eventListener.accept((id, vertexFormat, setter) -> {
                try {
                    ev.register(id, vertexFormat, setter);
                } catch (IOException e) {
                    throw new RuntimeException("Failed to register shader: " + id, e);
                }
            });
        });
    }

    public static void addItemRenderersRegistration(Consumer<ClientHelper.ItemRendererEvent> eventListener) {
        MoonlightFabricClient.PRE_CLIENT_SETUP_WORK.add(() -> {
            eventListener.accept((item, renderer) -> {
                var rend = renderer.getItemRenderer();
                if (rend instanceof BuiltinItemRendererRegistry.DynamicItemRenderer br) {
                    BuiltinItemRendererRegistry.INSTANCE.register(item, br);
                }
            });
        });
    }

}
