package net.mehvahdjukaar.moonlight.api.platform.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;

public class NetworkHelper {

    @ExpectPlatform
    public static void addNetworkRegistration(Consumer<RegisterMessagesEvent> eventListener, int version) {
        throw new AssertionError();
    }

    public interface RegisterMessagesEvent {
        <M extends Message> void registerServerBound(class_8710.class_9155<class_9129, M> messageType);

        <M extends Message> void registerClientBound(class_8710.class_9155<class_9129, M> messageType);

        <M extends Message> void registerBidirectional(class_8710.class_9155<class_9129, M> messageType);
    }


    @ExpectPlatform
    public static void sendToClientPlayer(class_3222 serverPlayer, class_8710 message) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void sendToAllClientPlayers(class_8710 message) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void sendToAllClientPlayersInRange(class_3218 level, class_2338 pos, double radius, class_8710 message) {
        throw new AssertionError();
    }

    public static void sendToAllClientPlayersInDefaultRange(class_3218 level, class_2338 pos, class_8710 message) {
        sendToAllClientPlayersInRange(level, pos, 64, message);
    }

    // same distance as serverlevel send particles
    public static void sendToAllClientPlayersInParticleRange(class_3218 level, class_2338 pos, class_8710 message){
        sendToAllClientPlayersInRange(level, pos, 32, message);
    }

    public static void sendToAllClientPlayersInDistantParticleRange(class_3218 level, class_2338 pos, class_8710 message){
        sendToAllClientPlayersInRange(level, pos, 512, message);
    }

    @ExpectPlatform
    public static void sendToAllClientPlayersTrackingEntity(class_1297 target, class_8710 message) {
        throw new AssertionError();
    }

    @Deprecated(forRemoval = true)
    public static void sentToAllClientPlayersTrackingEntity(class_1297 target, class_8710 message) {
        sendToAllClientPlayersTrackingEntity(target, message);
    }

    @Deprecated(forRemoval = true)
    public static void sentToAllClientPlayersTrackingEntityAndSelf(class_1297 target, Message message) {
        sendToAllClientPlayersTrackingEntityAndSelf(target, message);
    }

    @ExpectPlatform
    public static void sendToAllClientPlayersTrackingEntityAndSelf(class_1297 target, Message message) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void sendToServer(class_8710 message) {
        throw new AssertionError();
    }


}
