package net.mehvahdjukaar.moonlight.api.platform.network.fabric;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

import java.util.function.Consumer;

public class NetworkHelperImpl {

    public static void addNetworkRegistration(Consumer<NetworkHelper.RegisterMessagesEvent> eventListener, int version) {
        eventListener.accept(new NetworkHelper.RegisterMessagesEvent() {

            @Override
            public <M extends Message> void registerServerBound(class_8710.class_9155<class_9129, M> messageType) {
                PayloadTypeRegistry.playC2S().register(messageType.comp_2243(), messageType.comp_2244());

                ServerPlayNetworking.registerGlobalReceiver(messageType.comp_2243(),
                        (message, context) -> {
                            context.server().execute(() -> {
                                message.handle(new ContextWrapper(context));
                            });
                        });
            }


            @Override
            public <M extends Message> void registerClientBound(class_8710.class_9155<class_9129, M> messageType) {
                PayloadTypeRegistry.playS2C().register(messageType.comp_2243(), messageType.comp_2244());

                if (!PlatHelper.getPhysicalSide().isClient()) return;

                NetworkHelperImplClient.register(messageType);
            }

            @Override
            public <M extends Message> void registerBidirectional(class_8710.class_9155<class_9129, M> messageType) {
                this.registerServerBound(messageType);
                this.registerClientBound(messageType);
            }
        });

    }

    public record ContextWrapper(ServerPlayNetworking.Context c) implements Message.Context {

        @Override
        public Message.NetworkDir getDirection() {
            return Message.NetworkDir.SERVER_BOUND;
        }

        @Override
        public class_1657 getPlayer() {
            return c.player();
        }

        @Override
        public void disconnect(class_2561 reason) {
            c.responseSender().disconnect(reason);
        }

        @Override
        public void reply(class_8710 message) {
            c.responseSender().sendPacket(message);
        }
    }


    public static void sendToClientPlayer(class_3222 serverPlayer, class_8710 message) {
        ServerPlayNetworking.send(serverPlayer, message);
    }

    public static void sendToAllClientPlayers(class_8710 message) {
        for (var p : PlatHelper.getCurrentServer().method_3760().method_14571()) {
            sendToClientPlayer(p, message);
        }
    }

    public static void sendToAllClientPlayersInRange(class_3218 level, class_2338 pos, double radius, class_8710 message) {
        MinecraftServer currentServer = PlatHelper.getCurrentServer();
        if (!level.field_9236 && currentServer != null) {
            class_3324 players = currentServer.method_3760();
            var dimension = level.method_27983();

            players.method_14605(null, pos.method_10263(), pos.method_10264(), pos.method_10260(),
                    radius, dimension, ServerPlayNetworking.createS2CPacket(message));
        } else throw makeAssertionError();

    }

    private static @NotNull AssertionError makeAssertionError() {
        return new AssertionError("Cant send message to clients from client side!");
    }

    public static void sendToAllClientPlayersTrackingEntity(class_1297 target, class_8710 message) {
        class_1937 level = target.method_37908();
        if (level.field_9236) throw makeAssertionError();
        if (level instanceof class_3218 serverLevel) {
            serverLevel.method_14178().method_18754(target, ServerPlayNetworking.createS2CPacket(message));
        }
    }

    public static void sendToAllClientPlayersTrackingEntityAndSelf(class_1297 target, Message message) {
        class_1937 level = target.method_37908();
        if (level.field_9236) throw makeAssertionError();
        if (level instanceof class_3218 serverLevel) {
            var p = ServerPlayNetworking.createS2CPacket(message);
            serverLevel.method_14178().method_18754(target, p);
            if (target instanceof class_3222 player) {
                sendToClientPlayer(player, message);
            }
        }
    }

    public static void sendToServer(class_8710 message) {
        ClientPlayNetworking.send(message);
    }
}
