package net.mehvahdjukaar.moonlight.api.resources;

import com.google.common.base.Preconditions;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.recipe.BlockTypeSwapIngredient;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3975;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8786;
import net.minecraft.class_8957;
import net.minecraft.world.item.crafting.*;
import org.jetbrains.annotations.NotNull;

import java.util.*;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;

//TODO: change name
public class RecipeTemplate {

    private static final Map<Class<? extends class_1860<?>>, TriFunction<class_1860<?>, BlockType, BlockType, class_1860<?>>> REMAPPERS = new HashMap<>();

    public static <R extends class_1860<?>> void registerSimple(Class<R> type, RecipeFactory<R> factory) {
        register(type, (r, f, t) -> createSimple(r, factory, f, t));
    }

    /**
     * Register a recipe template for your recipe. Allows creating a copy of it with different ingredients
     */
    @Deprecated(forRemoval = true)
    public static <R extends class_1860<?>> void register(Class<R> type, BiFunction<R, UnaryOperator<class_1799>, R> factory) {
        //  REMAPPERS.put(type, (r, t) -> factory.apply((R) r, t));
        if (PlatHelper.isDev()) {
            throw new UnsupportedOperationException("You must register this using RecipeTemplate.register()");
        }
    }

    public static <R extends class_1860<?>> void register(Class<R> type, TriFunction<R, BlockType, BlockType, R> factory) {
        REMAPPERS.put(type, (r, f, t) -> factory.apply((R) r, f, t));
    }

    public interface RecipeFactory<R extends class_1860<?>> {
        R create(String group, class_7710 category, class_1799 result, class_2371<class_1856> ingredients);
    }

    @Deprecated(forRemoval = true)
    public static <T extends BlockType, R extends class_1860<?>> class_8786<?> makeSimilarRecipe(R original, T originalMat,
                                                                                               T destinationMat,
                                                                                               String baseID) {
        return makeSimilarRecipe(original, originalMat, destinationMat, class_2960.method_60654(baseID));
    }

    public static <T extends BlockType, R extends class_1860<?>> class_8786<?> makeSimilarRecipe(
            R original, @NotNull T originalMat, @NotNull T destinationMat,
            class_2960 baseID) {
        var clazz = original.getClass();
        var remapper = REMAPPERS.get(clazz);
        if (remapper == null) {
            throw new UnsupportedOperationException("Recipe class " + clazz + " not supported. You must register it using RecipeTemplate.register()");
        }
        class_2960 newId = baseID.method_45134(p -> p + "/" + destinationMat.getAppendableId());

        Preconditions.checkNotNull(original, "Found null from block type for remapping for recipe " + originalMat + " with id " + newId);
        Preconditions.checkNotNull(originalMat, "Found null from block type for remapping for recipe " + originalMat + " with id " + newId);

        var remapped = remapper.apply(original, originalMat, destinationMat);

        return new class_8786<>(newId, remapped);
    }

    static {
        register(class_1869.class, RecipeTemplate::createShaped);
        registerSimple(class_1867.class, class_1867::new);
        registerSimple(class_3975.class, (group, category, result, ingredients) ->
                new class_3975(group, ingredients.getFirst(), result));
    }


    private static <R extends class_1860<?>> R createSimple(R or, RecipeFactory<R> factory,
                                                        @NotNull BlockType from, @NotNull BlockType to) {
        Preconditions.checkNotNull(from, "Found null from block type for recipe remapping on recipe " + or);
        Preconditions.checkNotNull(to, "Found null to block type for recipe remapping on recipe " + or);
        List<class_1856> newList = convertIngredients(or.method_8117(), from, to);
        class_1799 originalResult = or.method_8110(class_5455.field_40585);
        class_1799 newResult = convertItemStack(originalResult, from, to);
        class_2371<class_1856> ingredients = class_2371.method_10212(class_1856.field_9017, newList.toArray(class_1856[]::new));

        class_7710 cat = class_7710.field_40251;
        if (or instanceof class_3955 cr) {
            cat = cr.method_45441();
        }
        return factory.create(or.method_8112(), cat, newResult, ingredients);
    }

    private static class_1869 createShaped(class_1869 or, @NotNull BlockType from, @NotNull BlockType to) {
        Preconditions.checkNotNull(from, "Found null from block type for recipe remapping on recipe " + or);
        Preconditions.checkNotNull(to, "Found null to block type for recipe remapping on recipe " + or);
        List<class_1856> newList = convertIngredients(or.method_8117(), from, to);
        class_1799 originalResult = or.method_8110(class_5455.field_40585);
        class_1799 newResult = convertItemStack(originalResult, from, to);
        class_2371<class_1856> ingredients = class_2371.method_10212(class_1856.field_9017, newList.toArray(class_1856[]::new));

        class_8957 pattern = new class_8957(or.method_8150(), or.method_8158(), ingredients,
                Optional.of(packRecipePattern(or.method_8150(), or.method_8158(), ingredients)));

        return new class_1869(or.method_8112(), or.method_45441(), pattern, newResult);
    }

    private static class_8957.class_8958 packRecipePattern(int width, int height, class_2371<class_1856> ingredients) {
        // Create a new map to hold the unique character keys and corresponding ingredients.
        Map<Character, class_1856> key = new HashMap<>();
        List<String> pattern = new ArrayList<>();

        char nextSymbol = 'A';  // Start with 'A' as the symbol for mapping ingredients.

        // Iterate over each row in the grid based on the width and height of the pattern.
        for (int row = 0; row < height; row++) {
            StringBuilder rowPattern = new StringBuilder();
            for (int col = 0; col < width; col++) {
                class_1856 ingredient = ingredients.get(row * width + col);

                // Check if ingredient is empty, then use space.
                if (ingredient.method_8103()) {
                    rowPattern.append(' ');
                } else {
                    // Check if ingredient already has an assigned symbol in the map.
                    Character symbol = null;
                    for (Map.Entry<Character, class_1856> entry : key.entrySet()) {
                        if (entry.getValue() == ingredient) {
                            symbol = entry.getKey();
                            break;
                        }
                    }

                    // If no symbol is found, assign a new one.
                    if (symbol == null) {
                        symbol = nextSymbol++;
                        key.put(symbol, ingredient);
                    }

                    rowPattern.append(symbol);
                }
            }
            // Add the constructed row to the pattern.
            pattern.add(rowPattern.toString());
        }
        return new class_8957.class_8958(key, pattern);
    }

    public static <T extends BlockType> class_1799 convertItemStack(class_1799 original, T from, T to) {
        class_1792 changed = BlockType.changeItemType(original.method_7909(), from, to);
        if (changed == null) {
            throw new UnsupportedOperationException("Failed to convert item stack: could not change " +
                    original.method_7909() + " from " + from.getId() + " to " + to.getId());
        }
        return original.method_60503(changed);
    }

    @Deprecated(forRemoval = true)
    public static <R extends class_1860<?>> @NotNull List<class_1856> convertIngredients(class_2371<class_1856> or,
                                                                                     UnaryOperator<class_1799> typeChanger) {
        List<class_1856> newList = new ArrayList<>(or);
        for (int i = 0; i < newList.size(); i++) {
            class_1856 ingredient = or.get(i);
            if (ingredient.method_8103()) continue;
            class_1799 intItem = typeChanger.apply(ingredient.method_8105()[0]);
            if (intItem != null) newList.set(i, class_1856.method_8101(intItem));
        }
        return newList;
    }

    public static <R extends class_1860<?>> @NotNull List<class_1856> convertIngredients(class_2371<class_1856> or,
                                                                                     @NotNull BlockType from, @NotNull BlockType to) {
        List<class_1856> newList = new ArrayList<>();
        Map<class_1856, class_1856> convertedMap = new HashMap<>();
        for (class_1856 ingredient : or) {
            if (ingredient.method_8103()) {
                newList.add(ingredient);
            } else {
                newList.add(convertedMap.computeIfAbsent(ingredient, i -> BlockTypeSwapIngredient.create(i, from, to)));
            }
        }
        return newList;
    }

}
