package net.mehvahdjukaar.moonlight.api.resources.pack;

import ;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import io.netty.util.internal.UnstableApi;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.integration.ModernFixCompat;
import net.minecraft.class_173;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_55;
import net.minecraft.class_77;
import net.minecraft.class_8490;
import net.minecraft.class_8786;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Optional;

@Deprecated(forRemoval = true)
public abstract class DynamicResourcePack extends InMemoryPackResources {

    protected static final Logger LOGGER = LogManager.getLogger();

    protected final class_3288.class_3289 position;

    public final String mainNamespace;
    public final class_2960 resourcePackName;
    private boolean needsClearingNonStatic = false;
    boolean addToStatic = false;

    protected DynamicResourcePack(class_2960 name, class_3264 type) {
        this(name, type, class_3288.class_3289.field_14280, false);
    }

    protected DynamicResourcePack(class_2960 name, class_3264 type, class_3288.class_3289 position, boolean fixed, boolean hidden) {
        this(name, type, position, hidden);
    }

    protected DynamicResourcePack(class_2960 name, class_3264 type, class_3288.class_3289 position, boolean hidden) {
        super(makeInfo(name), type, hidden);
        this.position = position;
        this.mainNamespace = name.method_12836();
        this.resourcePackName = name;
    }

    private static class_9224 makeInfo(class_2960 name) {
        return new class_9224(
                name.toString(),    // id
                class_2561.method_43471(LangBuilder.getReadableName(name.toString())), // title
                class_5352.field_25348,
                Optional.empty() //no clue what this is
        );
    }


    /**
     * Marks this texture as non-clearable.
     * By default, all textures will be cleared after texture atlases have been created
     * Call this for textures that are not on an atlas.
     */
    public void markNotClearable(class_2960 texturePath) {
    }

    public void unMarkNotClearable(class_2960 staticResources) {
    }

    public class_2960 id() {
        return resourcePackName;
    }

    @Override
    public String toString() {
        return method_14409();
    }

    public class_2561 getTitle() {
        return method_56926().comp_2330();
    }

    /**
     * Registers this pack. Call on mod init
     */
    //shit code here
    public void registerPack() {
        class_3264 packType = this.getPackType();
        DynamicResourcePack p = this;
        if (packType == class_3264.field_14188) {
            if (MoonlightClient.maybeMergeLegacyPack(this)) {
                return;
            }
        }
        RegHelper.registerResourcePack(packType, () ->
                class_3288.method_45275(
                        this.method_56926(),
                        new class_3288.class_7680() {
                            @Override
                            public class_3262 method_52424(class_9224 location) {
                                return p;
                            }

                            @Override
                            public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
                                return p;
                            }
                        },// pack supplier
                        packType,
                        new class_9225(
                                true,    // required -- this MAY need to be true for the pack to be enabled by default
                                class_3288.class_3289.field_14280,
                                false // fixed position
                        )
                ));
    }

    //@Override

    public FileNotFoundException makeFileNotFoundException(String path) {
        return new FileNotFoundException(String.format("'%s' in ResourcePack '%s'", path, this.resourcePackName));
    }


    @Deprecated(forRemoval = true)
    public void removeResource(class_2960 res) {
        synchronized (this) {
            this.searchTrie.remove(res);
            this.resources.remove(res);
        }
    }


    // Called after texture have been stitched. Only keeps needed stuff
    public final void clearNonStatic() {
        //not used anymore
    }

    // Called after each reload
    public void clearAllContent() {
        synchronized (this) {
            this.searchTrie.clear();
            this.resources.clear();
            this.needsClearingNonStatic = true; //clear non static after dynamic textures have been stitched
        }
    }

    private static final boolean MODERN_FIX = CompatHandler.MODERNFIX && ModernFixCompat.areLazyResourcesOn();

    private boolean modernFixHack(String s) {
        return s.startsWith("model") || s.startsWith("blockstate");
    }


    @Deprecated(forRemoval = true)
    public void addResource(StaticResource resource) {
        this.addResource(resource.location, resource.data);
    }

    @Deprecated(forRemoval = true)
    private void addJson(class_2960 path, JsonElement json) {
        try {
            this.addResource(path, RPUtils.serializeJson(json).getBytes());
        } catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", path, this.resourcePackName, e);
        }
    }

    @Deprecated(forRemoval = true)
    public void addJson(class_2960 location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    @Deprecated(forRemoval = true)
    public void addBytes(class_2960 location, byte[] bytes, ResType resType) {
        this.addResource(resType.getPath(location), bytes);
    }


    @Deprecated(forRemoval = true)
    public void addTag(SimpleTagBuilder builder, class_5321<?> type) {

        class_2960 tagId = builder.getId();
        String tagPath = type.method_29177().method_12832();
        class_2960 loc = ResType.TAGS.getPath(tagId.method_45136(tagPath + "/" + tagId.method_12832()));
        //merge tags
        //not needed anymore actually
        if (this.resources.containsKey(loc)) {
            var r = resources.get(loc);
            try (var stream = new ByteArrayInputStream(r)) {
                var oldTag = RPUtils.deserializeJson(stream);
                builder.addFromJson(oldTag);
            } catch (Exception ignored) {
            }
        }
        JsonElement json = builder.serializeToJson();
        this.addJson(loc, json, ResType.GENERIC);
    }

    /**
     * Adds a simple loot table that only drops the block itself
     *
     * @param block block to be dropped
     */
    @Deprecated(forRemoval = true)
    public void addSimpleBlockLootTable(class_2248 block) {
        this.addLootTable(block, createSingleItemTable(block)
                .method_334(class_173.field_1172));
    }

    @Deprecated(forRemoval = true)
    public void addLootTable(class_2248 block, class_52.class_53 table) {
        this.addLootTable(block.method_26162().method_29177(), table.method_338());
    }

    @Deprecated(forRemoval = true)
    public void addLootTable(class_2960 id, class_52 table) {
        this.addJson(id, class_8490.field_44498.comp_2520.encodeStart(JsonOps.INSTANCE, table).getOrThrow(), ResType.LOOT_TABLES);
    }

    protected static class_52.class_53 createSingleItemTable(class_1935 itemLike) {
        return class_52.method_324()
                .method_336(
                        class_55.method_347()
                                .method_352(class_44.method_32448(1.0F))
                                .method_351(class_77.method_411(itemLike)).method_354());
    }

    @Deprecated(forRemoval = true)
    public void addRecipe(class_8786<?> holder) {
        addRecipe(holder.comp_1933(), holder.comp_1932());
    }

    @UnstableApi
    public void addRecipe(class_1860<?> recipe, class_2960 id) {
        this.addRecipeNoAdvancement(recipe, id);

        //Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
        // ResourceLocation advancementId = recipe.getAdvancementId();
        //if (advancementId != null) {
        //  this.addJson(recipe.getAdvancementId(), recipe.serializeAdvancement(), ResType.ADVANCEMENTS);
        //}
    }

    @Deprecated(forRemoval = true)
    @UnstableApi
    public void addRecipeNoAdvancement(class_1860<?> recipe, class_2960 id) {
        this.addJson(id, RPUtils.writeRecipe(recipe), ResType.RECIPES);
    }


    @Deprecated(forRemoval = true)
    public void addAndCloseTexture(class_2960 path, TextureImage image) {
        addAndCloseTexture(path, image, true);
    }

    /**
     * Adds a new textures and closes the passed native image
     * Last boolean is for textures that aren't stitched so won't be cleared automatically after stitching
     * Use it for textures such as entity textures of GUI
     */
    @Deprecated(forRemoval = true)
    public void addAndCloseTexture(class_2960 path, TextureImage image, boolean isOnAtlas) {
        try (image) {
            this.addBytes(path, image.getImage().method_24036(), ResType.TEXTURES);
            if (!isOnAtlas) this.markNotClearable(ResType.TEXTURES.getPath(path));
            if (image.getMcMeta() != null) {
                this.addJson(path, image.getMcMeta().toJson(), ResType.MCMETA);
            }
        } catch (Exception e) {
            LOGGER.warn("Failed to add image {} to resource pack {}.", path, this, e);
        }
    }

    @Deprecated(forRemoval = true)
    public void addBlockModel(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCK_MODELS);
    }

    @Deprecated(forRemoval = true)
    public void addItemModel(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.ITEM_MODELS);
    }

    @Deprecated(forRemoval = true)
    public void addBlockState(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCKSTATES);
    }

    @Deprecated(forRemoval = true)
    public void addLang(class_2960 langName, JsonElement language) {
        this.addJson(langName, language, ResType.LANG);
    }

    @Deprecated(forRemoval = true)
    public void addLang(class_2960 langName, LangBuilder builder) {
        this.addJson(langName, builder.build(), ResType.LANG);
    }

    @Deprecated(forRemoval = true)
    public void setGenerateDebugResources(boolean generateDebugResources) {
    }

    @Deprecated(forRemoval = true)
    public void setClearOnReload(boolean canBeCleared) {
    }
}