package net.mehvahdjukaar.moonlight.api.resources.pack;

//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//


import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import net.mehvahdjukaar.moonlight.api.misc.ResourceLocationSearchTrie;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

//clone
public class FastSearchFilePackResources extends class_3255 {
    static final Logger LOGGER = LogUtils.getLogger();
    private final SharedZipFileAccess zipFileAccess;

    private final ResourceLocationSearchTrie searchTrie = new ResourceLocationSearchTrie();
    private final class_3264 packType;

    FastSearchFilePackResources(class_9224 location, File file,
                                class_3264 packType) {
        super(location);
        this.zipFileAccess = new SharedZipFileAccess(file);
        this.packType = packType;
        buildIndex();
    }

    private void buildIndex() {
        Stopwatch watch = Stopwatch.createStarted();
        try {
            ZipFile zip = this.zipFileAccess.getOrCreateZipFile();
            String pathName = this.packType.method_14413() + "/";
            assert zip != null;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) continue;
                String name = ze.getName();
                if (name.startsWith(pathName)) {
                    name = name.substring(pathName.length());
                } else {
                    continue;
                }
                searchTrie.insertPath(name); // assumes trie supports insert(String fullPath)
            }
        } catch (Exception e) {
            LOGGER.error("Failed to index zip file {}", this.zipFileAccess, e);
        } finally {
            Moonlight.LOGGER.info("Populated search tree for pack at {} in {}", this.zipFileAccess, watch);
        }
    }

    private static String getPathFromLocation(class_3264 packType, class_2960 location) {
        return String.format(Locale.ROOT, "%s/%s/%s", packType.method_14413(), location.method_12836(), location.method_12832());
    }

    @Nullable
    public class_7367<InputStream> method_14410(String... elements) {
        return this.getResource(String.join("/", elements));
    }

    @Override
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        if (packType != this.packType) return null;
        return this.getResource(getPathFromLocation(packType, location));
    }

    @Nullable
    private class_7367<InputStream> getResource(String resourcePath) {
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile == null) {
            return null;
        } else {
            ZipEntry zipEntry = zipFile.getEntry(resourcePath);
            return zipEntry == null ? null : class_7367.create(zipFile, zipEntry);
        }
    }

    @Override
    public Set<String> method_14406(class_3264 packType) {
        if (packType != this.packType) return Set.of();

        return new HashSet<>(this.searchTrie.listFolders(""));
    }

    @Override
    public void close() {
        this.zipFileAccess.close();
    }

    @Override
    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 output) {
        if (packType != this.packType) return;
        String prefix = packType.method_14413() + "/";
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile != null) {
            this.searchTrie.search(namespace + "/" + path)
                    .forEach(r -> {
                        ZipEntry zipEntry = zipFile.getEntry(prefix + r.method_12836()+"/"+r.method_12832());
                        if (zipEntry == null) {
                            throw new RuntimeException("Zip file entry was null");
                        }
                        output.accept(r, class_7367.create(zipFile, zipEntry));
                    });
        }
    }

    static class SharedZipFileAccess implements AutoCloseable {
        final File file;
        @Nullable
        private ZipFile zipFile;
        private boolean failedToLoad;

        SharedZipFileAccess(File file) {
            this.file = file;
        }

        @Nullable
        ZipFile getOrCreateZipFile() {
            if (this.failedToLoad) {
                return null;
            } else {
                if (this.zipFile == null) {
                    try {
                        this.zipFile = new ZipFile(this.file);
                    } catch (IOException var2) {
                        LOGGER.error("Failed to open pack {}", this.file, var2);
                        this.failedToLoad = true;
                        return null;
                    }
                }

                return this.zipFile;
            }
        }

        @Override
        public String toString() {
            return file.toString();
        }

        public void close() {
            if (this.zipFile != null) {
                IOUtils.closeQuietly(this.zipFile);
                this.zipFile = null;
            }

        }
    }
}
