//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import net.mehvahdjukaar.moonlight.api.misc.ResourceLocationSearchTrie;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_4239;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class FastSearchPathPackResources extends class_3255 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Joiner PATH_JOINER = Joiner.on("/");
    private final Path root;

    private final ResourceLocationSearchTrie searchTrie = new ResourceLocationSearchTrie();
    private final class_3264 packType;

    public FastSearchPathPackResources(class_9224 location, Path root, class_3264 packType) {
        super(location);
        this.root = root;
        this.packType = packType;
        buildIndex();
    }

    private void buildIndex() {
        Stopwatch watch = Stopwatch.createStarted();


        final Path base = this.root.resolve(this.packType.method_14413()); // "assets" or "data"

        if (!Files.exists(base)) {
            Moonlight.LOGGER.info("Pack at {} does not contain {}, skipping index", this.root, this.packType.method_14413());
            return;
        }

        try {
            // Walk all regular files under <root>/<assets|data>
            try (Stream<Path> stream = Files.find(base, Integer.MAX_VALUE,
                                 (p, attrs) -> attrs.isRegularFile())) {

                stream.forEach(file -> {
                    // Relativize to get "<namespace>/<rest/of/path>"
                    String rel = base.relativize(file).toString().replace('\\', '/');

                    int slash = rel.indexOf('/');
                    if (slash <= 0 || slash == rel.length() - 1) {
                        // No namespace or empty remainder -> skip
                        return;
                    }

                    String namespace = rel.substring(0, slash);
                    String pathWithinNs = rel.substring(slash + 1);

                    if (!class_2960.method_20209(namespace)) {
                        // Match vanilla behavior: warn and skip invalid namespaces
                        LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring",
                                namespace, this.root);
                        return;
                    }

                    class_2960 rl = class_2960.method_43902(namespace, pathWithinNs);
                    if (rl != null) {
                        this.searchTrie.insert(rl);
                    }
                });
            }

        } catch (IOException e) {
            LOGGER.error("Failed to build index for {}", base, e);
            // Mark built to avoid retry loops; remove this line if you prefer retry-on-next-call
        } finally {
            Moonlight.LOGGER.info("Populated search tree for pack at {} in {}", this.root, watch);
        }
    }

    @Nullable
    public class_7367<InputStream> method_14410(String... elements) {
        class_4239.method_46345(elements);
        Path path = class_4239.method_46344(this.root, List.of(elements));
        return Files.exists(path) ? class_7367.create(path) : null;
    }


    @Nullable
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        if (this.packType != packType) return null;
        Path path = this.root.resolve(packType.method_14413()).resolve(location.method_12836());
        return getResource(location, path);
    }

    @Nullable
    public static class_7367<InputStream> getResource(class_2960 location, Path path) {
        return class_4239.method_46346(location.method_12832()).mapOrElse((list) -> {
            Path path2 = class_4239.method_46344(path, list);
            return returnFileIfExists(path2);
        }, (error) -> {
            LOGGER.error("Invalid path {}: {}", location, error.message());
            return null;
        });
    }

    @Nullable
    private static class_7367<InputStream> returnFileIfExists(Path path) {
        return Files.exists(path) ? class_7367.create(path) : null;
    }

    @Override
    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 output) {
        if (packType != this.packType) return; // Optional guard, if you're storing `this.packType`

        this.searchTrie.search( namespace + "/" + path).forEach(resourceLocation -> {
            Path file = this.root
                    .resolve(packType.method_14413())   // e.g., "assets" or "data"
                    .resolve(resourceLocation.method_12836())
                    .resolve(resourceLocation.method_12832());

            if (Files.isRegularFile(file)) {
                output.accept(resourceLocation, class_7367.create(file));
            } else {
                LOGGER.warn("File not found or not regular: {} -> {}", resourceLocation, file);
            }
        });
    }

    @Override
    public Set<String> method_14406(class_3264 packType) {
        if (packType != this.packType) return Set.of();

        return new HashSet<>(this.searchTrie.listFolders(""));
    }

    public void close() {
    }
}
