package net.mehvahdjukaar.moonlight.api.resources.pack;

import ;
import dev.architectury.injectables.annotations.PlatformOnly;
import net.mehvahdjukaar.moonlight.api.misc.ResourceLocationSearchTrie;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryPackResources extends class_3255 implements IEditablePackResources, IDebugDumpable {

    protected final boolean hidden;
    protected final class_3264 packType;
    protected final class_3272 metadata;
    protected final Set<String> namespaces = new HashSet<>();
    protected final Map<class_2960, byte[]> resources = new ConcurrentHashMap<>();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<>();
    protected final ResourceLocationSearchTrie searchTrie = new ResourceLocationSearchTrie();

    protected InMemoryPackResources(class_9224 info, class_3264 type) {
        this(info, type, false);
    }

    protected InMemoryPackResources(class_9224 info, class_3264 type, boolean hidden) {
        super(info);
        this.packType = type;
        this.hidden = hidden;
        this.metadata = new class_3272(class_2561.method_43471("message.moonlight.runtime"),
                class_155.method_16673().method_48017(packType), Optional.empty());

    }


    @PlatformOnly(PlatformOnly.FORGE)
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public Set<String> method_14406(class_3264 packType) {
        if (packType != this.packType) return Set.of();
        return this.namespaces;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T method_14407(class_3270<T> serializer) {
        try {
            return serializer == class_3272.field_14202 ? (T) this.metadata : null;
        } catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    @Override
    public class_7367<InputStream> method_14410(String... strings) {
        String fileName = String.join("/", strings);
        byte[] resource = this.rootResources.get(fileName);
        return resource == null ? null : () -> new ByteArrayInputStream(resource);
    }

    @Override
    public void method_14408(class_3264 packType, String namespace, String id, class_7664 output) {
        //why are we only using server resources here?
        if (packType == this.packType) {
            //idk why but somebody had an issue with concurrency here during world load
            synchronized (this) {
                this.searchTrie .search(namespace + "/" + id)
                        .forEach(r -> {
                            byte[] buf = resources.get(r);
                            output.accept(r, () -> {
                                if (buf == null) {
                                    throw new IllegalStateException("Somehow search tree returned a resource not in resources " + r);
                                }
                                return new ByteArrayInputStream(buf);
                            });
                        });
            }
        }
    }

    @Override
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {

        var res = this.resources.get(id);
        if (res != null) {
            return () -> {
                if (type != this.packType) {
                    throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.method_14409()));
                }
                return new ByteArrayInputStream(res);
            };
        }
        return null;
    }

    @Override
    public void close() {
        // do not clear after reloading texture packs. should always be on
    }


    /**
     * Dynamic textures are loaded after getNamespaces is called, so unfortunately we need to know those in advance
     * Call this if you are adding stuff for another mod namespace
     **/
    @Override
    public void addNamespaces(String... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    @Override
    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Override
    public void addResource(class_2960 id, byte[] bytes) {
        synchronized (this) {
            this.namespaces.add(id.method_12836());
            this.resources.put(id, bytes);
            this.searchTrie.insert(id);
        }
    }

    @Override
    public void removeResource(class_2960 id) {
        synchronized (this) {
            this.resources.remove(id);
            this.searchTrie.remove(id);
        }
    }

    @Override
    public void removeRootResource(String name) {
        this.rootResources.remove(name);
    }

    @Override
    public boolean clearAllResources() {
        synchronized (this) {
            this.resources.clear();
            this.rootResources.clear();
            this.searchTrie.clear();
        }
        return true;
    }

    @Override
    public class_3264 getPackType() {
        return packType;
    }

    @Override
    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    @Override
    public void dumpToDisk(Path path) {
        this.resources.forEach((k, v) -> {
            try {
                Path p = RPUtils.getResourcePath(path, k, packType);
                Files.createDirectories(p.getParent());
                Files.write(p, v, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            } catch (IOException ignored) {
            }
        });
    }


}
