package net.mehvahdjukaar.moonlight.api.resources.pack;

import java.util.Collection;
import net.minecraft.class_3264;
import net.minecraft.class_9224;

//very ugly and confused class
public interface PackGenerationStrategy {

    boolean needsRegeneration(class_3264 packType);

    IEditablePackResources createPackResources(class_9224 info, class_3264 type);


    PackGenerationStrategy REGEN_ON_EVERY_RELOAD = new PackGenerationStrategy() {

        @Override
        public boolean needsRegeneration(class_3264 packType) {
            return true;
        }

        @Override
        public IEditablePackResources createPackResources(class_9224 info, class_3264 type) {
            return new InMemoryPackResources(info, type);
        }

        @Override
        public String toString() {
            return "REGEN_ON_EVERY_RELOAD";
        }
    };

    PackGenerationStrategy NO_OP = new PackGenerationStrategy() {

        @Override
        public boolean needsRegeneration(class_3264 packType) {
            return false;
        }

        @Override
        public IEditablePackResources createPackResources(class_9224 info, class_3264 type) {
            return new InMemoryPackResources(info, type);
        }

        @Override
        public String toString() {
            return "NO_OP";
        }
    };

    PackGenerationStrategy CACHED = new GlobalCachedStrategy();

    PackGenerationStrategy CACHED_ZIPPED = new GlobalCachedStrategy() {

        @Override
        public IEditablePackResources createPackResources(class_9224 info, class_3264 type) {
            return new CacheZipPackResources(info, type,
                    getPath(type).resolve(info.comp_2329().replace(":", "-")));

        }

        @Override
        public String toString() {
            return "CACHED_ZIPPED";
        }
    };

    static PackGenerationStrategy runOnce() {
        return new PackGenerationStrategy() {
            private boolean done = false;

            @Override
            public IEditablePackResources createPackResources(class_9224 info, class_3264 type) {
                return new InMemoryPackResources(info, type);
            }

            @Override
            public boolean needsRegeneration(class_3264 packType) {
                if (!done) {
                    done = true;
                    return true;
                }
                return false;
            }

            @Override
            public String toString() {
                return "RUN_ONCE";
            }
        };
    }

}
