package net.mehvahdjukaar.moonlight.api.resources.recipe;

import com.google.common.base.Preconditions;
import com.mojang.serialization.*;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.handler.codec.DecoderException;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class BlockTypeSwapIngredient<T extends BlockType> {


    @ExpectPlatform
    public static <T extends BlockType> class_1856 create(class_1856 original, @NotNull T from, @NotNull T to) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T extends BlockType> BlockTypeSwapIngredient<T> create(class_1856 original, @NotNull T from, @NotNull T to, BlockTypeRegistry<T> reg) {
        throw new AssertionError();
    }

    protected final class_1856 inner;
    protected final T fromType;
    protected final T toType;
    protected final BlockTypeRegistry<T> registry;

    private List<class_1799> items;

    protected BlockTypeSwapIngredient(class_1856 inner, T fromType, T toType, BlockTypeRegistry<T> reg) {
        super();
        Preconditions.checkNotNull(toType, "Found null to block type for BlockTypeSwapIngredient");
        Preconditions.checkNotNull(fromType, "Found null from block type for BlockTypeSwapIngredient");
        this.inner = inner;
        this.fromType = fromType;
        this.toType = toType;
        this.registry = reg;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BlockTypeSwapIngredient<?> ing && this.inner.equals(ing.inner)
                && this.fromType == ing.fromType && this.toType == ing.toType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(inner, fromType, toType);
    }

    public class_1856 getInner() {
        return inner;
    }

    public boolean test(class_1799 stack) {
        if (stack != null) {
            for (class_1799 itemStack : this.getMatchingStacks()) {
                if (itemStack.method_31574(stack.method_7909())) {
                    return true;
                }
            }
        }
        return false;
    }

    public final List<class_1799> convertItems(List<class_1799> toConvert) {
        List<class_1799> newItems = new ArrayList<>();
        boolean success = false;
        for (class_1799 it : toConvert) {
            var type = this.registry.getBlockTypeOf(it.method_7909());
            if (type != this.fromType) {
                break;
            } else {
                class_1792 newItem = BlockType.changeItemType(it.method_7909(), this.fromType, this.toType);
                if (newItem != null) {
                    newItems.add(it.method_60503(newItem));
                    success = true;
                }
            }
        }
        if (!success) {
            newItems.addAll(toConvert);
        }
        return newItems;
    }

    public List<class_1799> getMatchingStacks() {
        if (this.items == null) {
            this.items = convertItems(Arrays.asList(this.inner.method_8105()));
        }
        return this.items;
    }


    public static final class_2960 ID = Moonlight.res("block_type_swap");

    public static final MapCodec<BlockTypeSwapIngredient<?>> CODEC = makeCodec(false);
    public static final MapCodec<BlockTypeSwapIngredient<?>> CODEC_NONEMPTY = makeCodec(true);
    public static final class_9139<class_9129, BlockTypeSwapIngredient<?>> STREAM_CODEC =
            new class_9139<>() {
                @Override
                public BlockTypeSwapIngredient<?> decode(class_9129 object) {
                    class_1856 inner = class_1856.field_48355.decode(object);
                    BlockTypeRegistry<?> reg = BlockTypeRegistry.getRegistryStreamCodec().decode(object);
                    //this is slower but sends the full id so we have better error logging
                    var slowCodec = reg.getStreamCodecExplicit();
                    try {
                        BlockType from = slowCodec.decode(object);
                        BlockType to = slowCodec.decode(object);
                        return create(inner, from, to, (BlockTypeRegistry<? super BlockType>) reg);
                    } catch (DecoderException e) {
                        throw new RuntimeException("Failed to decode block type swap ingredient", e);
                    }
                }

                @Override
                public void encode(class_9129 buf, BlockTypeSwapIngredient<?> ing) {
                    class_1856.field_48355.encode(buf, ing.inner);
                    BlockTypeRegistry.getRegistryStreamCodec().encode(buf, ing.registry);
                    class_9139 streamCodec = ing.registry.getStreamCodecExplicit();
                    streamCodec.encode(buf, ing.fromType);
                    streamCodec.encode(buf, ing.toType);
                }
            };

    private static @NotNull MapCodec<BlockTypeSwapIngredient<?>> makeCodec(boolean nonEmpty) {
        return new MapCodec<>() {
            @Override
            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of("block_type", "from", "to", "ingredient").map(ops::createString);
            }

            @Override
            public <T> DataResult<BlockTypeSwapIngredient<?>> decode(DynamicOps<T> ops, MapLike<T> input) {
                var ingCodec = nonEmpty ? class_1856.field_46096 : class_1856.field_46095;
                DataResult<class_1856> ingResult = ingCodec.parse(ops, input.get(ops.createString("ingredient")));
                if (ingResult.isError()) {
                    return DataResult.error(() -> "Failed to decode inner ingredient: " + ingResult.error().get().message() + " on " + input);
                }
                class_1856 inner = ingResult.result().orElseThrow();
                T blockType = input.get(ops.createString("block_type"));
                DataResult<BlockTypeRegistry<?>> blockTypeResult = BlockTypeRegistry.getRegistryCodec().parse(ops, blockType);
                if (blockTypeResult.isError()) {
                    return DataResult.error(() -> "Failed to decode block type registry: " + blockType + " " + blockTypeResult.error().get().message() + " on " + input);
                }
                BlockTypeRegistry<?> reg = blockTypeResult.result().orElseThrow();
                T fromType = ops.createString("from");
                DataResult<?> fromResult = reg.getCodec().parse(ops, input.get(fromType));
                if (fromResult.isError()) {
                    return DataResult.error(() -> "Failed to decode 'from' block type: " + fromType + " " + fromResult.error().get().message() + " on " + input);
                }
                BlockType from = (BlockType) fromResult.result().orElseThrow();
                T toType = ops.createString("to");
                DataResult<?> toResult = reg.getCodec().parse(ops, input.get(toType));
                if (toResult.isError()) {
                    return DataResult.error(() -> "Failed to decode 'to' block type: " + toType + " " + toResult.error().get().message() + " on " + input);
                }
                BlockType to = (BlockType) toResult.result().orElseThrow();
                return DataResult.success(create(inner, from, to, (BlockTypeRegistry<? super BlockType>) reg));
            }

            @Override
            public <T> RecordBuilder<T> encode(BlockTypeSwapIngredient<?> ingr, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                var ingCodec = nonEmpty ? class_1856.field_46096 : class_1856.field_46095;
                prefix.add(ops.createString("ingredient"), ingCodec.encodeStart(ops, ingr.inner));
                prefix.add(ops.createString("block_type"), BlockTypeRegistry.getRegistryCodec().encodeStart(ops, ingr.registry));
                Codec codec = ingr.registry.getCodec();
                prefix.add(ops.createString("from"), codec.encodeStart(ops, ingr.fromType));
                prefix.add(ops.createString("to"), codec.encodeStart(ops, ingr.toType));
                return prefix;
            }
        };
    }


}
