package net.mehvahdjukaar.moonlight.api.resources.recipe.fabric;

import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.mehvahdjukaar.moonlight.api.resources.recipe.BlockTypeSwapIngredient;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class BlockTypeSwapIngredientImpl<T extends BlockType> extends BlockTypeSwapIngredient<T> implements CustomIngredient {

    protected BlockTypeSwapIngredientImpl(class_1856 inner, T fromType, T toType, BlockTypeRegistry<T> reg) {
        super(inner, fromType, toType, reg);
    }

    @Override
    public boolean requiresTesting() {
        return inner.requiresTesting();
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }


    public static CustomIngredientSerializer<BlockTypeSwapIngredientImpl<?>> SERIALIZER =
            new CustomIngredientSerializer<>() {

                @Override
                public class_2960 getIdentifier() {
                    return ID;
                }

                @Override
                public MapCodec<BlockTypeSwapIngredientImpl<?>> getCodec(boolean allowEmpty) {
                    return (MapCodec<BlockTypeSwapIngredientImpl<?>>) (Object) CODEC;
                }

                @Override
                public class_9139<class_9129, BlockTypeSwapIngredientImpl<?>> getPacketCodec() {
                    return (class_9139<class_9129, BlockTypeSwapIngredientImpl<?>>) (Object) STREAM_CODEC;
                }

            };

    public static <T extends BlockType> BlockTypeSwapIngredient<T> create(class_1856 original, T from, T to, BlockTypeRegistry<T> reg) {
        return new BlockTypeSwapIngredientImpl<>(original, from, to, reg);
    }

    public static <T extends BlockType> class_1856 create(class_1856 original, T from, T to) {
        return new BlockTypeSwapIngredientImpl<>(original, from, to, from.getRegistry())
                .toVanilla();
    }

    public static void register() {
        CustomIngredientSerializer.register(SERIALIZER);
    }
}
