package net.mehvahdjukaar.moonlight.api.resources.recipe.fabric;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditionType;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;

public class ResourceConditionsBridge {

    //registers equivalent of fabric conditions
    public static void init() {
        try {
            ResourceConditions.register(ModLoadedCondition.TYPE);
            ResourceConditions.register(TagEmptyCondition.TYPE);
            ResourceConditions.register(FALSE_TYPE);
        } catch (Exception e) {
            Moonlight.LOGGER.error("Failed to register fabric conditions", e);
        }
    }

    public record ModLoadedCondition(String modIds) implements ResourceCondition {
        public static final MapCodec<ModLoadedCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                Codec.STRING.fieldOf("modid").forGetter(ModLoadedCondition::modIds)
        ).apply(instance, ModLoadedCondition::new));


        public static final ResourceConditionType<ModLoadedCondition> TYPE = ResourceConditionType.create(
                class_2960.method_60654("fabric:mod_loaded"), ModLoadedCondition.CODEC);

        @Override
        public ResourceConditionType<?> getType() {
            return TYPE;
        }

        @Override
        public boolean test(@Nullable class_7225.class_7874 registryLookup) {
            return PlatHelper.isModLoaded(modIds);
        }
    }

    public record TagEmptyCondition(class_6862<class_1792> tag) implements ResourceCondition {
        public static final MapCodec<TagEmptyCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_6862.method_40090(class_7924.field_41197).fieldOf("tag").forGetter(TagEmptyCondition::tag)
        ).apply(instance, TagEmptyCondition::new));


        public static final ResourceConditionType<TagEmptyCondition> TYPE = ResourceConditionType.create(
                class_2960.method_60654("fabric:tag_empty"), TagEmptyCondition.CODEC);

        @Override
        public ResourceConditionType<?> getType() {
            return TYPE;
        }

        @Override
        public boolean test(@Nullable class_7225.class_7874 registryLookup) {
            if (registryLookup == null) {
                //not ideal... idk why registryLookup would be null... dub fabric as usual
                Moonlight.LOGGER.error("Registry Lookup was null, failing tag_empty resource condition check");
                return !ResourceConditionsImpl.tagsPopulated(tag.comp_326().method_29177(), List.of(tag.comp_327()));
            }
            var opt = registryLookup.method_46762(class_7924.field_41197).method_46733(tag);
            return opt.isEmpty() || opt.get().method_40239().findAny().isEmpty();
        }
    }


    public static final ResourceCondition FALSE = new ResourceCondition() {

        @Override
        public ResourceConditionType<?> getType() {
            return FALSE_TYPE;
        }

        @Override
        public boolean test(class_7225.@Nullable class_7874 registryLookup) {
            return false;
        }
    };

    public static final ResourceConditionType<ResourceCondition> FALSE_TYPE = ResourceConditionType.create(
            class_2960.method_60654("fabric:false"), MapCodec.unit(FALSE));

}
