package net.mehvahdjukaar.moonlight.api.set;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.INamedSupplier;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.integration.PolymerCompat;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public abstract class BlockTypeRegistry<T extends BlockType> implements class_2359<T> {


    public static Codec<BlockTypeRegistry<?>> getRegistryCodec() {
        return BlockSetInternal.getRegistriesCodec();
    }

    public static class_9139<ByteBuf, BlockTypeRegistry<?>> getRegistryStreamCodec() {
        return BlockSetInternal.getRegistriesStreamCodec();
    }

    protected boolean frozen = false;
    private final String name;
    private final List<BlockType.SetFinder<T>> finders = new ArrayList<>();
    private final Set<class_2960> notInclude = new HashSet<>();
    protected final MapRegistry<T> valuesReg;
    private final Class<T> typeClass;
    private final Object2ObjectOpenHashMap<Object, T> childrenToType = new Object2ObjectOpenHashMap<>();
    private final class_9139<ByteBuf, T> streamCodecSlow;

    protected BlockTypeRegistry(Class<T> typeClass, String name) {
        this.typeClass = typeClass;
        this.name = name;
        this.valuesReg = new MapRegistry<>(name);
        this.streamCodecSlow = class_9135.method_56368(this.getCodec());
    }

    @Override
    public @NotNull Iterator<T> iterator() {
        return valuesReg.iterator();
    }

    @Override
    public int method_10204() {
        return valuesReg.method_10204();
    }

    @Override
    public @Nullable T method_10200(int id) {
        return valuesReg.method_10200(id);
    }

    @Override
    public int getId(T value) {
        return valuesReg.method_10206(value);
    }

    public boolean isFrozen() {
        return frozen;
    }

    public Class<T> getType() {
        return typeClass;
    }

    /**
     * Gets corresponding block type or oak if the provided one is not installed or missing
     *
     * @param name string resource location name of the type
     * @return wood type
     */
    @Deprecated(forRemoval = true)
    public T getFromNBT(String name) {
        return valuesReg.getValueOrDefault(class_2960.method_60654(name), this.getDefaultType());
    }

    @Nullable
    public T get(class_2960 res) {
        if (!frozen && (!isBeingFrozenHack || PlatHelper.isDev())) {
            throw new AssertionError("Tried to get an object from block set registry before the registry was finalized.");
        }
        return valuesReg.getValue(res);
    }

    public class_2960 getKey(T input) {
        return valuesReg.getKey(input);
    }

    public Codec<T> getCodec() {
        return valuesReg;
    }

    // use MappedRegistries instead
    @Deprecated(forRemoval = true)
    public class_9139<ByteBuf, T> getStreamCodec(){
        return streamCodecSlow;
    }

    public class_9139<ByteBuf, T> getStreamCodecExplicit() {
        return streamCodecSlow;
    }

    public abstract T getDefaultType();

    public Collection<T> getValues() {
        return valuesReg.getValues();
    }

    public String typeName() {
        return name;
    }

    /**
     * Returns an optional block Type based on the given block. Pretty much defines the logic of how a block set is constructed
     */
    protected abstract Optional<T> detectTypeFromBlock(class_2248 block, class_2960 blockId);

    protected T register(T newType) {
        if (frozen) {
            throw new UnsupportedOperationException("Tried to register a block types after registry events");
        }
        //ignore duplicates
        if (!valuesReg.containsKey(newType.id)) {
            valuesReg.register(newType.id, newType);
        }
        return newType;
    }

    @Deprecated(forRemoval = true)
    public Collection<BlockType.SetFinder<T>> getFinders() {
        return List.of();
    }

    public synchronized void addFinder(BlockType.SetFinder<T> finder) {
        if (frozen) {
            throw new UnsupportedOperationException("Tried to register a block type finder after registry events");
        }
        finders.add(finder);
    }

    public synchronized void addRemover(class_2960 id) {
        if (frozen) {
            throw new UnsupportedOperationException("Tried remove a block type after registry events");
        }
        notInclude.add(id);
    }

    @ApiStatus.Internal
    public void finalizeAndFreeze() {
        if (frozen) {
            throw new UnsupportedOperationException("Block types are already finalized");
        }
        this.frozen = true;


        this.getValues().forEach(BlockType::initializeChildrenBlocks);
        this.getValues().forEach(BlockType::initializeChildrenItems);
    }

    @Deprecated(forRemoval = true)
    boolean isBeingFrozenHack = false;

    @ApiStatus.Internal
    public void buildAll() {
        if (!frozen) {
            //adds default
            isBeingFrozenHack = true;
            T defaultType = this.getDefaultType();
            if (defaultType != null) this.register(defaultType);
            //adds finders
            finders.stream().map(BlockType.SetFinder::get).forEach(f -> f.ifPresent(this::register));

            for (class_2248 b : class_7923.field_41175) {
                //skip stuff that wont be on the client
                if (CompatHandler.POLYMER && PolymerCompat.isPolymerObj(b)) continue;
                this.detectTypeFromBlock(b, Utils.getID(b)).ifPresent(t -> {
                    if (!notInclude.contains(t.getId())) this.register(t);
                });
            }
            isBeingFrozenHack = false;
            finders.clear();
            notInclude.clear();
        }

    }

    /**
     * Called at the right time on language reload. Use to add translations of your block type names.
     * Useful to merge more complex translation strings using RPAwareDynamicTextureProvider::addDynamicLanguage
     */
    @ApiStatus.Internal
    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach((blockType) -> {
            if (language.isDefault()) language.addEntry(blockType.getTranslationKey(), blockType.getReadableName());
        });
    }

    @Nullable
    public T getBlockTypeOf(class_1935 itemLike) {
        //we must check items and blocks correctly here since map might just contain blocks or items
        var blockType = childrenToType.get(itemLike);
        if (blockType != null) return blockType;
        if (itemLike == class_1802.field_8162 || itemLike == class_2246.field_10124) return null;
        if (itemLike instanceof class_1747 bi) {
            var ofBlock = childrenToType.get(bi.method_7711());
            if (ofBlock != null) return ofBlock;
        }
        if (itemLike instanceof class_2248 block) {
            class_1792 item = block.method_8389();
            if (item == class_1802.field_8162) {
                throw new IllegalStateException("Block " + block + " has no item. This likely means getBlockTypeOf was called too early. This is a bug");
            }
            return childrenToType.get(item);
        }
        return null;
    }

    // we cant add items yet. item map has not been populated yet
    protected void mapObjectToType(Object itemLike, BlockType type) {
        this.childrenToType.put(itemLike, (T) type);
        if (itemLike instanceof class_1747 bi) {
            if (!this.childrenToType.containsKey(bi.method_7711()))
                this.childrenToType.put(bi.method_7711(), (T) type);
        }
    }

    // load priority. higher is loaded first. 100 is default
    public int priority() {
        return 100;
    }

    public INamedSupplier<T> makeFutureHolder(class_2960 id) {
        return INamedSupplier.memoize(id, () -> this.get(id));
    }
}
