package net.mehvahdjukaar.moonlight.api.set.leaves;

import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class LeavesTypeRegistry extends BlockTypeRegistry<LeavesType> {

    public static final LeavesTypeRegistry INSTANCE = new LeavesTypeRegistry();

    /// USE {@link VanillaLeavesTypes#OAK}
    @Deprecated(forRemoval = true)
    public static LeavesType OAK_TYPE = VanillaLeavesTypes.OAK;
/// USE {@link LeavesTypeRegistry}.{@link LeavesTypeRegistry#INSTANCE}
    @Deprecated(forRemoval = true)
    public static Collection<LeavesType> getTypes() {
        return INSTANCE.getValues();
    }

    /// USE {@link VanillaLeavesTypes}.woodTypeId, <br>For example "spruce", then use VanillaLeavesTypes.SPRUCE
    @Deprecated(forRemoval = true)
    @Nullable
    public static LeavesType getValue(class_2960 leavesTypeId) {
        return INSTANCE.get(leavesTypeId);
    }

    /// USE {@link VanillaLeavesTypes}.woodTypeId, <br>For example "spruce", then use VanillaLeavesTypes.SPRUCE
    @Deprecated(forRemoval = true)
    @Nullable
    public static LeavesType getValue(String leavesTypeId) {
        return INSTANCE.get(class_2960.method_60654(leavesTypeId));
    }

    @Deprecated(forRemoval = true)
    public static LeavesType fromNBT(String name) {
        return INSTANCE.getFromNBT(name);
    }


    private final Map<class_2960, class_2960> specialLeavesToWood = new HashMap<>();
    private final Map<LeavesType, WoodType> leavesToWood = new IdentityHashMap<>();

    public LeavesTypeRegistry() {
        super(LeavesType.class, "leaves_type");

        LeavesType.CODEC = this.getCodec();
        LeavesType.STREAM_CODEC = this.getStreamCodecExplicit();
    }

    static void touch() {
    }

    @Override
    /// manual registry method. Only for Vanilla LeavesType
    protected LeavesType register(LeavesType vanillaType) {
        return super.register(vanillaType);
    }

    @Override
    public LeavesType getDefaultType() {
        return VanillaLeavesTypes.OAK;
    }

    @Nullable
    public WoodType getEquivalentWoodType(LeavesType leavesType) {
        return leavesToWood.get(leavesType);
    }

    //returns if this block is the base plank block
    @Override
    public Optional<LeavesType> detectTypeFromBlock(class_2248 baseBlock, class_2960 baseId) {
        String name = null;
        String path = baseId.method_12832();
        //needs to contain planks in its name
        if (path.endsWith("_leaves")) {
            name = path.substring(0, path.length() - "_leaves" .length());
        } else if (path.startsWith("leaves_")) {
            name = path.substring("leaves_" .length());
        }
        String namespace = baseId.method_12836();
        if (name != null && !namespace.equals("securitycraft") && !path.contains("hanging")) {
            if (baseBlock instanceof class_2397) {
                class_2960 id = baseId.method_45136(name);
                if (!valuesReg.containsKey(id)) return Optional.of(new LeavesType(id, baseBlock));
            }
        }
        return Optional.empty();
    }

    //- BLACKLISTED_MODS
    private static boolean isBlacklisted(String namespace, String path) {
        return namespace.equals("securitycraft") || namespace.equals("dynamic_trees") ||
                namespace.matches("dynamictrees|dt\\w+") || path.contains("hanging");
    }


    @Override
    public void finalizeAndFreeze() {
        super.finalizeAndFreeze();

        // add wood to leaves mapping. we know this runs after wood types are registered
        for (var l : this.getValues()) {
            class_2960 leavesId = l.id;
            class_2960 id = specialLeavesToWood.getOrDefault(leavesId, leavesId);
            WoodType o = WoodTypeRegistry.INSTANCE.get(id);
            String path = id.method_12832();
            String namespace = id.method_12836();
            if (o == null) {
                for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
                    if (w.id.method_12832().equals(path)) {
                        o = w;
                        break;
                    }
                }
            }
            if (o == null) {
                //this assigns "variant leaves types" to their expected vanilla woods
                //i.e. "blossoming_oak" -> "oak"
                for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
                    if (w.isVanilla() || w.id.method_12836().equals(namespace)) { //true vanilla
                        if (path.endsWith(w.id.method_12832())) {
                            o = w;
                            //don't break to avoid associating "oak" instead of "dark_oak"
                        }
                    }
                }
            }
            if (o != null) {
                leavesToWood.put(l, o);
            }
        }
    }


    // Adds a mapping from leaves type to wood type.
    // Used for non-conventional wood types or leaves types that don't have a log
    public void addLeavesToWoodMapping(class_2960 leavesTypeId, class_2960 woodTypeId) {
        specialLeavesToWood.put(leavesTypeId, woodTypeId);
    }

    public void addLeavesToWoodMapping(String leavedId, String woodId) {
        addLeavesToWoodMapping(class_2960.method_60654(leavedId), class_2960.method_60654(woodId));
    }

    public void addLeavesToWoodMapping(String modId, String leavesTypeName, String woodTypeName) {
        addLeavesToWoodMapping(class_2960.method_60655(modId, leavesTypeName), class_2960.method_60655(modId, woodTypeName));
    }

    @Override
    public int priority() {
        return 99;
    }

    //shorthand for add finder. Gives a builder-like object that's meant to be configured inline
    public LeavesType.Finder addSimpleFinder(class_2960 typeId) {
        LeavesType.Finder finder = new LeavesType.Finder(typeId);
        this.addFinder(finder);
        return finder;
    }


    public LeavesType.Finder addSimpleFinder(String typeId) {
        return addSimpleFinder(class_2960.method_60654(typeId));
    }

    public LeavesType.Finder addSimpleFinder(String namespace, String name) {
        return addSimpleFinder(class_2960.method_60655(namespace, name));
    }

}
