package net.mehvahdjukaar.moonlight.api.set.wood;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1690;
import net.minecraft.class_1690.class_1692;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2478;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_4970.class_2251;
import net.minecraft.class_7713;
import net.minecraft.class_7923;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.*;

/**
 * CHILD AVAILABLITY:
 * <p>BLOCK:</p>
 * <ul>
 * planks, log, stripped_log, wood, stripped_wood, leaves,
 * slab, stairs, fence, fence_gate, door, trapdoor,
 * button, pressure_plate, hanging_sign, wall_hanging_sign, sign, wall_sign
 * </ul>
 * <p>ITEM:</p>
 * <ul>
 * boat, chest_boat, sapling
 * </ul>
 */
public class WoodType extends BlockType {

    public static Codec<WoodType> CODEC;
    public static class_9139<ByteBuf, WoodType> STREAM_CODEC;

    public static Supplier<class_2941<WoodType>> ENTITY_SERIALIZER;

    static {
        WoodTypeRegistry.touch();
    }

    public final class_2248 planks;
    public final class_2248 log;

    // like this so it can be called early. not too early tho as children might not be initialized
    //mega ugly. i cant initialize it immediately as mods might have not run setup yet
    private final Supplier<net.minecraft.class_4719> vanillaType = Suppliers.memoize(this::detectVanillaWood);

    private final Supplier<class_1690.class_1692> boatType = Suppliers.memoize(this::detectVanillaBoat);

    @Nullable
    private class_1690.class_1692 detectVanillaBoat() {
        if (this == VanillaWoodTypes.OAK) return class_1690.class_1692.field_7727;
        var id = this.getId();
        var conventions = Set.of(id.method_12832(),
                id.method_12836() + id.method_12832(),
                id.method_12836() + "_" + id.method_12832(),
                id.method_12836() + "/" + id.method_12832(),
                id.toString());
        for (var s : conventions) {
            var o = class_1690.class_1692.method_7561(s);
            if (o != class_1690.class_1692.field_7727) {
                return o;
            }
        }
        return null;
    }

    @Nullable
    private net.minecraft.class_4719 detectVanillaWood() {
        if (getChild("hanging_sign") instanceof class_7713 c) {
            return c.method_24025();
        }
        if (getChild("sign") instanceof class_2478 f) {
            return f.method_24025();
        }
        String i = id.method_12836().equals("minecraft") ? id.method_12832() : id.toString();
        var values = net.minecraft.class_4719.method_24026();
        var o = values.filter(v -> v.comp_1299().equals(i)).findAny();
        return o.orElse(null);
    }

    public WoodType(class_2960 id, class_2248 baseBlock, class_2248 logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
    }

    @Override
    public class_1935 mainChild() {
        return planks;
    }

    @Nullable
    public net.minecraft.class_4719 toVanilla() {
        return this.vanillaType.get();
    }

    @Nullable
    public class_1690.class_1692 toVanillaBoat() {
        return this.boatType.get();
    }

    @NotNull
    public net.minecraft.class_4719 toVanillaOrOak() {
        var v = toVanilla();
        if (v != null) return v;
        return net.minecraft.class_4719.field_21676;
    }

    @NotNull
    public class_1690.class_1692 toVanillaBoatOrOak() {
        var v = toVanillaBoat();
        if (v != null) return v;
        return class_1690.class_1692.field_7727;
    }

    /**
     * Use this to get the texture path of a wood type
     *
     * @return something like minecraft/oak
     */
    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) return this.getTypeName();
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.planks.method_9564().method_50011();
    }

    public class_3620 getColor() {
        return this.planks.method_26403();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild(PLANKS, this.planks);
        this.addChild(LOG, this.log);
        this.addChild(LEAVES, this.findRelatedEntry("leaves", class_7923.field_41175));
        this.addChild(WOOD, this.findLogRelatedBlock("", "wood", "hyphae", "bark"));
        this.addChild(STRIPPED_LOG, this.findStrippedLog(LOG, "stem", "stalk"));
        this.addChild(STRIPPED_WOOD, this.findStrippedLog(WOOD, "hyphae", "bark"));
        this.addChild(SLAB, this.findRelatedEntry("slab", class_7923.field_41175));
        this.addChild(STAIRS, this.findRelatedEntry("stairs", class_7923.field_41175));
        class_2248 fence = this.findRelatedEntry("fence", class_7923.field_41175);
        this.addChild(FENCE, fence);
        this.addChild(FENCE_GATE, this.findRelatedEntry("fence_gate", class_7923.field_41175));
        this.addChild(DOOR, this.findRelatedEntry("door", class_7923.field_41175));
        this.addChild(TRAPDOOR, this.findRelatedEntry("trapdoor", class_7923.field_41175));
        this.addChild(BUTTON, this.findRelatedEntry("button", class_7923.field_41175));
        this.addChild(PRESSURE_PLATE, this.findRelatedEntry("pressure_plate", class_7923.field_41175));
        this.addChild(HANGING_SIGN, this.findRelatedEntry("hanging_sign", class_7923.field_41175));
        this.addChild(WALL_HANGING_SIGN, this.findRelatedEntry("wall_hanging_sign", class_7923.field_41175));
        this.addChild(SIGN, this.findRelatedEntry("sign", class_7923.field_41175));
        this.addChild(WALL_SIGN, this.findRelatedEntry("wall_sign", class_7923.field_41175));

        if (this.id.method_12836().matches("tfc|afc")) { // Including unidue blocks' path
            this.addChild(SIGN, this.findRelatedEntry("sign", "", class_7923.field_41175));
            this.addChild(HANGING_SIGN, this.findRelatedEntry("hanging_sign/wrought_sign", "", class_7923.field_41175));
        }

        if (fence != null && CompatHandler.DIAGONALFENCES) {
            var diagonalFence = class_7923.field_41175.method_17966(
                    class_2960.method_60655("diagonalfences", Utils.getID(fence)
                            .toString().replace(":", "/")));
            diagonalFence.ifPresent(block -> this.addChild("diagonalfences:fence", block));
        }
    }

    @Override
    public void initializeChildrenItems() {
        if (this.id.toString().equals("minecraft:bamboo")) {
            this.addChild("boat", this.findRelatedEntry("raft", class_7923.field_41178));
            this.addChild("chest_boat", this.findRelatedEntry("chest_raft", class_7923.field_41178));
        } else {
            this.addChild(BOAT, this.findRelatedItem("boat", "raft"));
            this.addChild(CHEST_BOAT, this.findRelatedItem("chest_boat", "chest_raft"));
        }
        this.addChild(SAPLING, this.findRelatedEntry("sapling", class_7923.field_41178));
        if (this.id.method_12836().matches("tfc|afc")) { // Including unidue blocks' path
            this.addChild(STICK, this.findRelatedEntry("twig", class_7923.field_41175));
            this.addChild(BOAT, this.findRelatedEntry("boat", "", class_7923.field_41175));
        }
    }


    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, class_2378<V> reg) {
        if (!suffix.isEmpty()) suffix = "_" + suffix;
        class_2960[] targets = {
                class_2960.method_60655(id.method_12836(), id.method_12832() + "_" + prefixOrInfix + suffix),
                class_2960.method_60655(id.method_12836(), prefixOrInfix + "_" + id.method_12832() + suffix),
                //weird conventions here
                id.method_45136(id.method_12832() + "_planks_" + prefixOrInfix + suffix),
                // TFC & AFC: Include children of wood_type: stairs, slab...
                id.method_45136("wood/planks/" + id.method_12832() + "_" + prefixOrInfix),
                // TFC & AFC: Include twig (sticks), leaves, planks, sign
                id.method_45136("wood/" + prefixOrInfix + suffix + "/" + id.method_12832())
        };
        return Utils.findFirstInRegistry(reg, targets);
    }


    @Nullable
    protected class_2248 findStrippedLog(String... possibleNames) {
        for (var v : possibleNames) {
            class_2248 b = this.getBlockOfThis(v);
            if (v != null) {
                class_2248 stripped = class_1743.field_7898.get(b);
                if (stripped != null && stripped != b) {
                    return stripped;
                }
            }
        }
        return findLogRelatedBlock("stripped", possibleNames);
    }

    @Nullable
    protected class_1792 findRelatedItem(String... names) {
        for (var n : names) {
            var b = findRelatedEntry(n, class_7923.field_41178);
            if (b != null) return b;
        }
        return null;
    }

    @Nullable
    protected class_2248 findLogRelatedBlock(String prefix, String... possibleSuffix) {
        for (var n : possibleSuffix) {
            class_2248 b = findLogWithAffix(prefix, n);
            if (b != null) return b;
        }
        return null;
    }

    @Nullable
    protected class_2248 findLogWithAffix(String prefix, String suffix) {
        // ugly, shouldnt be here
        // SUPPORT: TFC & AFC
        if (this.id.method_12836().matches("tfc|afc")) {
            String prefix_ = prefix.isEmpty() ? "" : prefix + "_";
            var o = class_7923.field_41175.method_17966(
                    class_2960.method_60655(this.getNamespace(),
                            "wood/" + prefix_ + suffix + "/" + id.method_12832()));
            if (o.isPresent()) return o.get();
        }

        List<class_2960> targets = makeKnownIDConventionsAffix(
                this.id.method_12836(), this.id.method_12832(),
                prefix, suffix, Utils.getID(this.log).method_12832());
        return Utils.findFirstInRegistry(class_7923.field_41175, targets);
    }

    private static @NotNull List<class_2960> makeKnownIDConventionsAffix(
            String myNamespace, String myPath,
            String prefixOrInfix, String suffix,
            @Nullable String alternateNamespace) {

        boolean noneEmpty = !prefixOrInfix.isEmpty() && !suffix.isEmpty();
        String prefix_ = prefixOrInfix.isEmpty() ? "" : prefixOrInfix + "_";
        String _infix = prefixOrInfix.isEmpty() ? "" : "_" + prefixOrInfix;
        String _suffix = suffix.isEmpty() ? "" : "_" + suffix;

        List<class_2960> targets = new ArrayList<>();
        targets.add(class_2960.method_60655(myNamespace, myPath + _infix + _suffix));
        targets.add(class_2960.method_60655(myNamespace, prefix_ + myPath + _suffix));
        if (alternateNamespace != null)
            targets.add(class_2960.method_60655(myNamespace, alternateNamespace + _infix + _suffix));
        if (noneEmpty && alternateNamespace != null)
            targets.add(class_2960.method_60655(myNamespace, prefix_ + alternateNamespace + _suffix));

        //For things like grimwood_wood -> grimwood
        if (myPath.endsWith(suffix)) {
            targets.add(class_2960.method_60655(myNamespace, prefix_ + myPath));
        }
        return targets;
    }

    static List<class_2960> makeKnownIDConventions(class_2960 id, String... affixKeyword) {
        String myPath = id.method_12832();
        String myNamespace = id.method_12836();
        List<class_2960> possibleTargets = new ArrayList<>();
        for (String affix : affixKeyword) {
            possibleTargets.addAll(makeKnownIDConventionsAffix(myNamespace, myPath, "", affix, null));
            possibleTargets.addAll(makeKnownIDConventionsAffix(myNamespace, myPath, affix, "", null));
        }
        return possibleTargets;
    }

    @Nullable
    static class_2248 findLog(class_2960 id) {
        var tests = makeKnownIDConventions(id, "log", "stem", "stalk", "hyphae");
        return Utils.findFirstInRegistry(class_7923.field_41175, tests);
    }

    @Nullable
    static class_2248 findPlanks(class_2960 id) {
        var tests = makeKnownIDConventions(id, "planks", "plank");
        return Utils.findFirstInRegistry(class_7923.field_41175, tests);
    }


    //just copies base properties without calling copy
    public class_4970.class_2251 copyProperties() {
        var p = class_4970.class_2251.method_9637();
        p.method_31710(this.getColor());
        if (this.canBurn()) p.method_50013();
        p.method_9626(this.getSound());
        return p;
    }


    //TODO:move in wood registry class
    public static class Finder extends SetFinderBuilder<WoodType> {
        private Supplier<class_2248> planksFinder;
        private Supplier<class_2248> logFinder;

        public Finder(class_2960 id) {
            super(id, WoodTypeRegistry.INSTANCE);
            this.log(() -> findLog(id)); // defaults
            this.planks(() -> findPlanks(id)); // defaults
        }

        /// PLANKS \\\
        public Finder planks(Supplier<class_2248> planksFinder) {
            this.planksFinder = planksFinder;
            return this;
        }

        public Finder planks(class_2960 id) {
            return this.planks(() -> class_7923.field_41175.method_17966(id).orElseThrow(
                    () -> new IllegalStateException("Failed to find planks block: " + id)
            ));
        }

        public Finder planks(String planksName) {
            return this.planks(Utils.idWithOptionalNamespace(planksName, id.method_12836()));
        }

        /**
         * @param prefix include the underscore, "_" if the blockId has one
         * @param suffix include the underscore, "_" if the blockId has one
         */
        public Finder planksAffix(String prefix, String suffix) {
            return planks(prefix + id.method_12832() + suffix);
        }

        /**
         * @param suffix include the underscore, "_" if the blockId has one
         */
        @SuppressWarnings("UnusedReturnValue")
        public Finder planksSuffix(String suffix) {
            return planks(id.method_12832() + suffix);
        }

        /// LOG \\\
        public Finder log(Supplier<class_2248> logFinder) {
            this.logFinder = logFinder;
            return this;
        }

        /// @param id Full Id of MudType as ResourceLocation
        public Finder log(class_2960 id) {
            return this.log(() -> class_7923.field_41175.method_17966(id).orElseThrow(
                    () -> new IllegalStateException("Failed to find log block: " + id)));
        }

        /// @param nameLog name of Log without modId or namespace
        public Finder log(String nameLog) {
            return this.log(Utils.idWithOptionalNamespace(nameLog, id.method_12836()));
        }

        /**
         * @param prefix include the underscore, "_" if the blockId has one
         * @param suffix include the underscore, "_" if the blockId has one
         */
        public Finder logAffix(String prefix, String suffix) {
            return log(prefix + id.method_12832() + suffix);
        }

        /**
         * @param suffix include the underscore, "_" if the blockId has one
         */
        public Finder logSuffix(String suffix) {
            return log(id.method_12832() + suffix);
        }


        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatHelper.isModLoaded(id.method_12836())) {
                try {
                    class_2248 plank = Preconditions.checkNotNull(planksFinder.get(), "Manual Finder - failed to find a plank block for {}", id);
                    class_2248 log = Preconditions.checkNotNull(logFinder.get(), "Manual Finder - failed to find a log block for {}", id);
                    var woodType = new WoodType(id, plank, log);
                    childNames.forEach((key, value) -> {
                        try {
                            class_1935 obj = Preconditions.checkNotNull(value.get());
                            woodType.addChild(key, obj);
                        } catch (Exception e) {
                            Moonlight.LOGGER.warn("Failed to find child for WoodType: {} - {}. Ignored! ERROR: {}", id, key, e.getMessage());
                        }
                    });
                    return Optional.of(woodType);
                } catch (Exception e) {
                    Moonlight.LOGGER.warn("Failed to find custom WoodType:  {} - ", id, e);
                }
            }
            return Optional.empty();
        }

// ─────────────────────────────────────────── Marked For Removal ────────────────────────────────────────────

        /// USE {@link WoodTypeRegistry#addSimpleFinder(String, String)}
        @Deprecated(forRemoval = true)
        public Finder(class_2960 id, Supplier<class_2248> planks, Supplier<class_2248> log) {
            super(id, WoodTypeRegistry.INSTANCE);
            this.planksFinder = planks;
            this.logFinder = log;
        }

        /// USE {@link WoodTypeRegistry#addSimpleFinder(String, String)}
        @Deprecated(forRemoval = true)
        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return simple(class_2960.method_60655(modId, woodTypeName), class_2960.method_60655(modId, planksName),
                    class_2960.method_60655(modId, logName));
        }

        /// USE {@link WoodTypeRegistry#addSimpleFinder(String, String)}
        @Deprecated(forRemoval = true)
        public static Finder simple(class_2960 woodTypeName, class_2960 planksName, class_2960 logName) {
            return new Finder(woodTypeName,
                    () -> class_7923.field_41175.method_10223(planksName),
                    () -> class_7923.field_41175.method_10223(logName));
        }

        /**
         * USE {@link WoodTypeRegistry#addSimpleFinder(String, String)}
         * <br>add {@link SetFinderBuilder#childBlockAffix(String, String, String)}
         * <br>OR
         * <br>add {@link SetFinderBuilder#childBlockSuffix(String, String)}
         */
        @Deprecated(forRemoval = true)
        public void addChild(String childType, String childName) {
            this.childBlock(childType, childName);
        }

        /**
         * USE {@link WoodTypeRegistry#addSimpleFinder(String, String)}
         * <br>add {@link SetFinderBuilder#childBlockAffix(String, String, String)}
         * <br>OR
         * <br>add {@link SetFinderBuilder#childBlockSuffix(String, String)}
         */
        @Deprecated(forRemoval = true)
        public void addChild(String childType, class_2960 childName) {
            this.childBlock(childType, childName);
        }

    }

}
