package net.mehvahdjukaar.moonlight.api.set.wood;

import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class WoodTypeRegistry extends BlockTypeRegistry<WoodType> {

    public static final WoodTypeRegistry INSTANCE = new WoodTypeRegistry();

    /// USE {@link VanillaWoodTypes#OAK}
    @Deprecated(forRemoval = true)
    public static final WoodType OAK_TYPE = VanillaWoodTypes.OAK;

    /// USE {@link WoodTypeRegistry}.{@link WoodTypeRegistry#INSTANCE}
    @Deprecated(forRemoval = true)
    public static Collection<WoodType> getTypes() {
        return INSTANCE.getValues();
    }

    /// USE {@link VanillaWoodTypes}.woodTypeId, <br>for example "spruce", then use VanillaWoodTypes.SPRUCE
    @Deprecated(forRemoval = true)
    @Nullable
    public static WoodType getValue(class_2960 woodTypeId) {
        return INSTANCE.get(woodTypeId);
    }

    /// USE {@link VanillaWoodTypes}.woodTypeId, <br>for example "spruce", then use VanillaWoodTypes.SPRUCE
    @Deprecated(forRemoval = true)
    @Nullable
    public static WoodType getValue(String woodTypeId) {
        return INSTANCE.get(class_2960.method_60654(woodTypeId));
    }

    @Deprecated(forRemoval = true)
    public static WoodType fromNBT(String name) {
        return INSTANCE.getFromNBT(name);
    }

    @Deprecated(forRemoval = true)
    public static WoodType fromVanilla(net.minecraft.class_4719 vanillaType) {
        return INSTANCE.getFromVanilla(vanillaType);
    }

    //instance stuff

    private final Map<net.minecraft.class_4719, WoodType> fromVanilla = new IdentityHashMap<>();

    public WoodTypeRegistry() {
        super(WoodType.class, "wood_type");
        this.addFinder(() -> {
            var b = new WoodType(class_2960.method_60654("bamboo"), class_2246.field_40294, class_2246.field_41072);
            b.addChild("stripped_log", class_2246.field_41073);
            return Optional.of(b);
        });

        WoodType.CODEC = this.getCodec();
        WoodType.STREAM_CODEC = this.getStreamCodecExplicit();

        WoodType.ENTITY_SERIALIZER = RegHelper.registerEntityDataSerializer(Moonlight.res("wood_type"),
                () -> class_2941.method_56031(this.getStreamCodecExplicit()));
    }

    static void touch() {
    }

    @Override
    /// manual registry method. Only for Vanilla WoodType
    protected WoodType register(WoodType vanillaType) {
        return super.register(vanillaType);
    }

    @Override
    public WoodType getDefaultType() {
        return VanillaWoodTypes.OAK;
    }

    //- BLACKLISTED_MODS
    public static Set<String> IGNORED_MODS = new HashSet<>(Set.of(
            "chipped", "compressedblocks", "securitycraft",
            "absentbydesign", "immersive_weathering", "dynamictrees", "dt"
    ));

    //returns if this block is the base plank block
    @Override
    public Optional<WoodType> detectTypeFromBlock(class_2248 baseBlock, class_2960 baseId) {
        String name = null;
        String path = baseId.method_12832();

        /// Support TerraFirmaCraft (TFC) & ArborFirmaCraft (AFC)
        if (baseId.method_12836().equals("tfc") || baseId.method_12836().equals("afc")) {
            // Needs to contain palnks in its path
            if (path.contains("wood/planks/")) {
                var log = class_7923.field_41175.method_17966(
                        baseId.method_45136(path.replace("planks", "log")));
                if (log.isPresent()) {
                    class_2960 id = baseId.method_45136(path.replace("wood/planks/", ""));
                    return Optional.of(new WoodType(id, baseBlock, log.get()));
                }
            }
            return Optional.empty();
        }

        // DEFAULT
        if (path.endsWith("_planks")) { //needs to contain planks in its name
            name = path.substring(0, path.length() - "_planks" .length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_" .length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank" .length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_" .length());
        }
        String namespace = baseId.method_12836();
        if (name != null && !IGNORED_MODS.contains(namespace)) {

            class_2680 state = baseBlock.method_9564();
            //Can't check if the block is a full one, so I do this. Adding some checks here
            if (state.method_28501().size() <= 2 && !(baseBlock instanceof class_2482)) {
                //needs to use wood sound type
                //we do not allow "/" in the wood name
                name = name.replace("/", "_");
                class_2960 id = baseId.method_45136(name);
                class_2248 logBlock = WoodType.findLog(id);
                if (logBlock != null && !valuesReg.containsKey(id)) {
                    return Optional.of(new WoodType(id, baseBlock, logBlock));
                }
            }
        }
        return Optional.empty();
    }

    @Nullable
    public WoodType getFromVanilla(net.minecraft.class_4719 woodType) {
        if (fromVanilla.isEmpty()) {
            for (WoodType w : getValues()) {
                var vanilla = w.toVanilla();
                if (vanilla != null) fromVanilla.put(vanilla, w);
            }
        }
        return fromVanilla.get(woodType);
    }

    //shorthand for add finder. Gives a builder-like object that's meant to be configured inline
    public WoodType.Finder addSimpleFinder(class_2960 woodTypeId) {
        WoodType.Finder finder = new WoodType.Finder(woodTypeId);
        this.addFinder(finder);
        return finder;
    }


    public WoodType.Finder addSimpleFinder(String nameWoodType) {
        return addSimpleFinder(class_2960.method_60654(nameWoodType));
    }

    public WoodType.Finder addSimpleFinder(String namespace, String nameWoodType) {
        return addSimpleFinder(class_2960.method_60655(namespace, nameWoodType));
    }
}
