package net.mehvahdjukaar.moonlight.api.trades;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Map.Entry;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1914;
import net.minecraft.class_3854;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public record BiomeVariantItemListing(Map<class_3854, ModItemListing> listingMap,
                                      ModItemListing defaultListing) implements ModItemListing {

    public static final MapCodec<BiomeVariantItemListing> CODEC = RecordCodecBuilder.<BiomeVariantItemListing>mapCodec(instance -> instance.group(
                    Codec.unboundedMap(
                            class_7923.field_41194.method_39673(),
                            ModItemListing.CODEC
                    ).fieldOf("trades_per_type").forGetter(BiomeVariantItemListing::listingMap),
                    ModItemListing.CODEC.fieldOf("default").forGetter(BiomeVariantItemListing::defaultListing)
            ).apply(instance, BiomeVariantItemListing::new))
            .validate(
                    listing -> {
                        //check level are the same
                        int originalLevel = listing.defaultListing.getLevel();
                        for (var entry : listing.listingMap.entrySet()) {
                            if (entry.getValue().getLevel() != originalLevel) {
                                return DataResult.error(() -> "All listings must have the same level");
                            }
                        }
                        return DataResult.success(listing);
                    }
            );


    @Override
    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    @Override
    public @Nullable class_1914 method_7246(class_1297 trader, class_5819 random) {
        if (trader instanceof class_1646 villager) {
            class_3854 villagerType = villager.method_7231().method_16919();
            ModItemListing listing = this.listingMap.get(villagerType);
            if (listing != null) {
                return listing.method_7246(trader, random);
            }
        }
        return this.defaultListing.method_7246(trader, random);
    }

    @Override
    public int getLevel() {
        return defaultListing.getLevel();
    }
}
