package net.mehvahdjukaar.moonlight.api.util;

import com.google.common.base.Suppliers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_2960;

public interface INamedSupplier<T> extends Supplier<T> {

    @Nullable
    class_2960 getId();

    @Nullable
    T get();

    @NotNull
    default T getOrThrow() {
        var t = get();
        if (t == null) throw new AssertionError("Failed to get object with ID " + getId());
        return t;
    }

    static <T> INamedSupplier<T> memoize(class_2960 id, Supplier<T> supp) {
        var instance = Suppliers.memoize(supp::get);
        return new INamedSupplier<>() {
            @Override
            public class_2960 getId() {
                return id;
            }

            @Override
            public T get() {
                return instance.get();
            }
        };
    }

}
