package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import net.minecraft.class_7876;
import net.minecraft.core.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

// copy and paste of HolderSetCodec with lenient list
public class LenientHolderSetCodec<E> implements Codec<class_6885<E>> {
    private final class_5321<? extends class_2378<E>> registryKey;
    private final Codec<class_6880<E>> elementCodec;
    private final Codec<List<class_6880<E>>> homogenousListCodec;
    private final Codec<Either<class_6862<E>, List<class_6880<E>>>> registryAwareCodec;

    private static <E> Codec<List<class_6880<E>>> homogenousList(Codec<class_6880<E>> holderCodec, boolean disallowInline) {
        Codec<List<class_6880<E>>> codec = LenientListCodec.of(holderCodec).validate(class_5699.method_40114(class_6880::method_40231));
        return disallowInline
                ? codec
                : Codec.either(codec, holderCodec)
                .xmap(either -> either.map(list -> list, List::of), list -> list.size() == 1 ? Either.right(list.get(0)) : Either.left(list));
    }

    public static <E> Codec<class_6885<E>> create(class_5321<? extends class_2378<E>> registryKey, Codec<class_6880<E>> holderCodec, boolean disallowInline) {
        return new LenientHolderSetCodec<>(registryKey, holderCodec, disallowInline);
    }

    private LenientHolderSetCodec(class_5321<? extends class_2378<E>> registryKey, Codec<class_6880<E>> elementCodec, boolean disallowInline) {
        this.registryKey = registryKey;
        this.elementCodec = elementCodec;
        this.homogenousListCodec = homogenousList(elementCodec, disallowInline);
        this.registryAwareCodec = Codec.either(class_6862.method_40093(registryKey), this.homogenousListCodec);
    }

    @Override
    public <T> DataResult<Pair<class_6885<E>, T>> decode(DynamicOps<T> dynamicOps, T object) {
        if (dynamicOps instanceof class_6903<T> registryOps) {
            Optional<class_7871<E>> optional = registryOps.method_46634(this.registryKey);
            if (optional.isPresent()) {
                class_7871<E> holderGetter = optional.get();
                return this.registryAwareCodec
                        .decode(dynamicOps, object)
                        .flatMap(
                                pair -> {
                                    DataResult<class_6885<E>> dataResult = (pair.getFirst())
                                            .map(tagKey -> lookupTag(holderGetter, tagKey), list -> DataResult.success(class_6885.method_40242(list)));
                                    return dataResult.map(holderSet -> Pair.of(holderSet, pair.getSecond()));
                                }
                        );
            }
        }

        return this.decodeWithoutRegistry(dynamicOps, object);
    }

    private static <E> DataResult<class_6885<E>> lookupTag(class_7871<E> input, class_6862<E> tagKey) {
        return (DataResult<class_6885<E>>) (Object) input.method_46733(tagKey)
                .map(DataResult::success)
                .orElseGet(() -> DataResult.error(() -> "Missing tag: '" + tagKey.comp_327() + "' in '" + tagKey.comp_326().method_29177() + "'"));
    }

    public <T> DataResult<T> encode(class_6885<E> input, DynamicOps<T> ops, T prefix) {
        if (ops instanceof class_6903<T> registryOps) {
            Optional<class_7876<E>> optional = registryOps.method_46628(this.registryKey);
            if (optional.isPresent()) {
                if (!input.method_46768(optional.get())) {
                    return DataResult.error(() -> "HolderSet " + input + " is not valid in current registry set");
                }

                return this.registryAwareCodec.encode(input.method_40248().mapRight(List::copyOf), ops, prefix);
            }
        }

        return this.encodeWithoutRegistry(input, ops, prefix);
    }

    private <T> DataResult<Pair<class_6885<E>, T>> decodeWithoutRegistry(DynamicOps<T> ops, T input) {
        return this.elementCodec.listOf().decode(ops, input).flatMap(pair -> {
            List<class_6880.class_6881<E>> list = new ArrayList<>();

            for (class_6880<E> holder : pair.getFirst()) {
                if (!(holder instanceof class_6880.class_6881)) {
                    return DataResult.error(() -> "Can't decode element " + holder + " without registry");
                }

                class_6880.class_6881<E> direct = (class_6880.class_6881) holder;
                list.add(direct);
            }

            return DataResult.success(new Pair<>(class_6885.method_40242(list), pair.getSecond()));
        });
    }

    private <T> DataResult<T> encodeWithoutRegistry(class_6885<E> input, DynamicOps<T> ops, T prefix) {
        return this.homogenousListCodec.encode(input.method_40239().toList(), ops, prefix);
    }
}
