package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.serialization.Codec;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_1812;
import net.minecraft.class_1828;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;

public enum PotionBottleType implements class_3542 {
    REGULAR("item.minecraft.potion"),
    SPLASH("item.minecraft.splash_potion"),
    LINGERING("item.minecraft.lingering_potion");

    private final String name;
    private final class_2561 translatedName;

    PotionBottleType(String translatedKey) {
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.translatedName = class_2561.method_43471(translatedKey);
    }

    public static final Codec<PotionBottleType> CODEC = class_3542.method_53955(PotionBottleType::values);

    public class_1799 getDefaultItem() {
        return (switch (this) {
            case REGULAR -> class_1802.field_8574;
            case LINGERING -> class_1802.field_8150;
            case SPLASH -> class_1802.field_8436;
        }).method_7854();
    }

    public class_2561 getTranslatedName() {
        return translatedName;
    }

    @Override
    public String method_15434() {
        return name;
    }

    @Nullable
    public static PotionBottleType get(class_1792 potionItem) {
        if (potionItem instanceof class_1828) return SPLASH;
        else if (potionItem instanceof class_1803) return LINGERING;
        else if (potionItem instanceof class_1812) return REGULAR;
        return null;
    }

    public static PotionBottleType getOrDefault(class_1792 filledContainer) {
        PotionBottleType type = get(filledContainer);
        return type != null ? type : REGULAR;
    }

    public static PotionBottleType getOrDefault(SoftFluidStack stack) {
        return stack.method_57825(MoonlightRegistry.BOTTLE_TYPE.get(), REGULAR);
    }

}
