package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.BaseMapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.util.internal.UnstableApi;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.InvPlacer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_2985;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_4970;
import net.minecraft.class_4970.class_2251;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5455;
import net.minecraft.class_5455.class_6890;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6899;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8779;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.core.*;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;


public class Utils {

    public static void spawnItemWithTileData(class_1657 player, class_2621 tile) {
        class_1937 level = player.method_37908();
        if (!level.field_9236 && player.method_7337() && !tile.method_5442()) {
            class_2338 pos = tile.method_11016();
            class_1799 itemstack = saveTileToItem(tile);

            class_1542 itementity = new class_1542(level, pos.method_10263() + 0.5D, pos.method_10264() + 0.5D, pos.method_10260() + 0.5D, itemstack);
            itementity.method_6988();
            level.method_8649(itementity);
        } else {
            tile.method_54873(player);
        }
    }

    public static class_1799 saveTileToItem(class_2586 tile) {
        class_2248 block = tile.method_11010().method_26204();
        class_1799 stack = new class_1799(block.method_8389());
        tile.method_38240(stack, tile.method_10997().method_30349());
        return stack;
    }

    public static void loadTileFromItem(class_2586 tile, class_1799 stack) {
        var comp = stack.method_57824(class_9334.field_49611);
        if (comp != null) {
            tile.method_58690(comp.method_57461(), tile.method_10997().method_30349());
        }
    }

    public static void swapItem(class_1657 player, class_1268 hand, class_1799 oldItem, class_1799 newItem, boolean bothSides) {
        if (!player.method_37908().field_9236 || bothSides)
            player.method_6122(hand, class_5328.method_30270(oldItem.method_7972(), player, newItem, player.method_7337()));
    }

    public static void swapItem(class_1657 player, class_1268 hand, class_1799 oldItem, class_1799 newItem) {
        swapItem(player, hand, oldItem, newItem, false);
    }

    public static void swapItemNBT(class_1657 player, class_1268 hand, class_1799 oldItem, class_1799 newItem) {
        if (!player.method_37908().field_9236)
            player.method_6122(hand, class_5328.method_30270(oldItem.method_7972(), player, newItem, false));
    }

    public static void swapItem(class_1657 player, class_1268 hand, class_1799 newItem) {
        swapItem(player, hand, player.method_5998(hand), newItem);
    }

    //TODO: add more stuff from item utils

    @Deprecated(forRemoval = true)
    public static void addStackToExisting(class_1657 player, class_1799 stack, boolean avoidEmptyHands) {
        addItemOrDrop(player, stack, avoidEmptyHands ? InvPlacer.handOrExistingOrAnyAvoidEmptyHand(class_1268.field_5808) : InvPlacer.handOrExistingOrAny(class_1268.field_5808));
    }

    /**
     * Adds an item to the player's inventory, uses the given strategy to determine where to place it
     */
    public static void addItemOrDrop(class_1657 player, class_1799 stack, InvPlacer placer) {
        class_1661 inv = player.method_31548();
        placer.or(InvPlacer.DROP).place(stack, inv, player);
    }

    public static void addItemOrDrop(class_1657 player, class_1799 stack) {
        addItemOrDrop(player, stack, InvPlacer.existingOrAny()); //default impl
    }


    //xp bottle logic
    public static int getXPinaBottle(int bottleCount, class_5819 rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; i++) xp += (3 + rand.method_43048(5) + rand.method_43048(5));
        return xp;
    }

    public static class_2960 getId(class_6880<?> object) {
        return object.method_40230().get().method_29177();
    }

    public static class_2960 getID(@NotNull class_2248 object) {
        return class_7923.field_41175.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1299<?> object) {
        return class_7923.field_41177.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1959 object) {
        return hackyGetRegistry(class_7924.field_41236).method_10221(object);
    }

    public static class_2960 getID(@NotNull class_8110 type) {
        return hackyGetRegistry(class_7924.field_42534).method_10221(type);
    }

    public static class_2960 getID(@NotNull class_2975<?, ?> object) {
        return hackyGetRegistry(class_7924.field_41239).method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1792 object) {
        return class_7923.field_41178.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_3611 object) {
        return class_7923.field_41173.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_2591<?> object) {
        return class_7923.field_41181.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1865<?> object) {
        return class_7923.field_41189.method_10221(object);
    }

    @Deprecated(forRemoval = true)
    public static class_2960 getID(@NotNull SoftFluid object) {
        return SoftFluidRegistry.hackyGetRegistry().method_10221(object);
    }

    @Deprecated(forRemoval = true)
    public static class_2960 getID(@NotNull MLMapDecorationType<?, ?> object) {
        return MapDataInternal.hackyGetRegistry().method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1842 object) {
        return class_7923.field_41179.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1291 object) {
        return class_7923.field_41174.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1761 object) {
        return class_7923.field_44687.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_3448<?> object) {
        return class_7923.field_41193.method_10221(object);
    }

    public static class_2960 getID(@NotNull Object object) {
        return switch (object) {
            case Block b -> getID(b);
            case Item b -> getID(b);
            case EntityType<?> b -> getID(b);
            case BlockEntityType<?> b -> getID(b);
            case Biome b -> getID(b);
            case Fluid b -> getID(b);
            case RecipeSerializer<?> b -> getID(b);
            case ConfiguredFeature<?, ?> c -> getID(c);
            case Potion c -> getID(c);
            case MobEffect c -> getID(c);
            case Supplier<?> s -> getID(s.get());
            case SoftFluid s -> getID(s);
            case MLMapDecorationType<?, ?> s -> getID(s);
            case CreativeModeTab t -> getID(t);
            case DamageType t -> getID(t);
            case StatType<?> t -> getID(t);
            case Holder<?> h -> getId(h);
            default -> throw new UnsupportedOperationException("Unsupported class type " +
                    object.getClass() + ". Expected a registry entry for a call to Utils.getID()");
        };
    }

    @Deprecated(forRemoval = true)
    public static <T> boolean isTagged(T entry, class_2378<T> registry, class_6862<T> tag) {
        return registry.method_47983(entry).method_40220(tag);
    }

    // finds the right registry access to which a data pack entry belongs to
    public static <T> class_7225.class_7226<T> hackyFindRegistryOf(
            class_6880<T> holder, class_5321<class_2378<T>> registryKey) {
        if (holder instanceof class_6880.class_6883<T> ref) {
            if (ref.field_40930 instanceof class_7225.class_7226<T> ra) {
                return ra;
            }
        }
        if (PlatHelper.getPhysicalSide().isClient()) {
            var level = class_310.method_1551().field_1687;
            if (level != null) {
                var clientRa = level.method_30349();
                class_2378<T> r = clientRa.method_30530(registryKey);
                if (holder.method_46745(r.method_46770())) {
                    return clientRa.method_46762(registryKey);
                }
            }
        }
        var s = PlatHelper.getCurrentServer();
        if (s != null) {
            var serverRa = s.method_30611();
            class_2378<T> r = serverRa.method_30530(registryKey);
            if (holder.method_46745(r.method_46770())) {
                return serverRa.method_46762(registryKey);
            }
        }
        throw new UnsupportedOperationException("Failed to find registry access for " + holder);
    }

    //very very hacky
    //attempts to grab the right registry access for the current thread, hopefully matching the logical side one
    @UnstableApi
    public static class_5455 hackyGetRegistryAccess() {
        var s = PlatHelper.getCurrentServer();
        if (PlatHelper.getPhysicalSide().isClient()) {
            if (s != null && (s.method_18854() || !MoonlightClient.isClientThread())) return s.method_30611();
            var level = class_310.method_1551().field_1687;
            if (level != null) return level.method_30349();
            var hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
            if (hack2 != null) return hack2.get();
            throw new UnsupportedOperationException("Failed to get registry access: level was null");
        }
        if (s != null) return s.method_30611();
        var hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
        if (hack2 != null) return hack2.get();
        throw new UnsupportedOperationException("Failed to get registry access. This is a bug");
    }

    @UnstableApi
    public static <T> class_2378<T> hackyGetRegistry(class_5321<class_2378<T>> key) {
        return hackyGetRegistryAccess().method_30530(key);
    }


    /**
     * Copies block properties without keeping stupid lambdas that could include references to the wrong blockstate properties
     */
    public static class_4970.class_2251 copyPropertySafe(class_2248 blockBehaviour) {
        var p = class_4970.class_2251.method_9630(blockBehaviour);
        class_2680 state = blockBehaviour.method_9564();
        p.method_9631(s -> state.method_26213());
        p.method_49229(class_4970.class_2250.field_10656);
        p.method_26235((blockState, blockGetter, pos, entityType) ->
                blockState.method_26206(blockGetter, pos, class_2350.field_11036) && blockState.method_26213() < 14);
        p.method_31710(blockBehaviour.method_26403());
        p.method_26249((blockState, blockGetter, blockPos) -> false);
        //TODO: this isnt safe anymore... in 1.21
        return p;
    }

    public static void awardAdvancement(class_3222 sp, class_2960 name) {
        awardAdvancement(sp, name, "unlock");
    }

    public static void awardAdvancement(class_3222 sp, class_2960 name, String unlockProp) {
        class_8779 advancement = sp.method_5682().method_3851().method_12896(name);
        if (advancement != null) {
            class_2985 advancements = sp.method_14236();
            if (!advancements.method_12882(advancement).method_740()) {
                advancements.method_12878(advancement, unlockProp);
            }
        }
    }

    @Nullable
    public static <E extends class_2586, A extends class_2586> class_5558<A> getTicker(class_2591<A> type, class_2591<E> targetType, class_5558<? super E> ticker) {
        return targetType == type ? (class_5558<A>) ticker : null;
    }

    @Nullable
    public static <E extends class_2586, A extends class_2586> class_5558<A> getTicker(
            class_2591<A> type, class_2591<E> targetType,
            Consumer<A> tickFunc) {
        return targetType == type ?
        (level, blockPos, blockState, blockEntity) -> tickFunc.accept(blockEntity) : null;
    }


    public static class_2680 readBlockState(class_2487 compound, @Nullable class_1937 level) {
        class_7871<class_2248> holderGetter = level != null ? level.method_45448(class_7924.field_41254) : class_7923.field_41175.method_46771();
        return class_2512.method_10681(holderGetter, compound);
    }

    public static <T extends Comparable<T>, A extends class_2769<T>> class_2680 replaceProperty(class_2680 from, class_2680 to, A property) {
        if (from.method_28498(property)) {
            return to.method_11657(property, from.method_11654(property));
        }
        return to;
    }

    /**
     * Call this instead of player.abilities.mayBuild. Mainly used for adventure mode ege case
     * <p>
     * This is needed as vanilla handles most of its block altering actions from the item class which calls this.
     * In a Block class this should be called instead to allow adventure mode to work properly
     * <p>
     * Call when placing or modifying a block. Checks edge cases like spectator
     * Needed also in BLOCK use methods. or other places. not item I believe
     */
    public static boolean mayPerformBlockAction(class_1657 player, class_2338 pos, class_1799 stack) {
        class_1934 gameMode;
        if (player instanceof class_3222 sp) {
            gameMode = sp.field_13974.method_14257();
        } else {
            gameMode = class_310.method_1551().field_1761.method_2920();
        }
        //we don't have context so we check both can break and can place. this below already check canBreak
        //this only checks the adventure mode canDestroyTag tag
        boolean result = !player.method_21701(player.method_37908(), pos, gameMode);
        if (!result) {
            //also checks this because vanilla doesn't as it does not place blocks in block use method
            //also vanilla tends to allow a bunch of unpreventable adventure interactions

            if (gameMode == class_1934.field_9216 && !stack.method_7960()) {
                if (stack.method_57357(new class_2694(player.method_37908(), pos, false))) {
                    return true;
                }
            }
        }
        return result;
    }

    public static boolean isMethodImplemented(Class<?> original, Class<?> subclass, String name) {
        Method declaredMethod = findMethodWithMatchingName(subclass, name);
        Method modMethod = findMethodWithMatchingName(original, name);
        return declaredMethod != null && modMethod != null && Arrays.equals(declaredMethod.getParameterTypes(), modMethod.getParameterTypes());
    }

    private static Method findMethodWithMatchingName(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getName().equals(name)) {
                return method;
            }
        }
        return null;
    }


    @ExpectPlatform
    public static <K, V, C extends BaseMapCodec<K, V> & Codec<Map<K, V>>> C optionalMapCodec(final Codec<K> keyCodec, final Codec<V> elementCodec) {
        throw new AssertionError();
    }

    public static <T> Codec<T> optionalRegistryCodec(class_2378<T> reg, T defaultValue) {
        return class_2960.field_25139.xmap(
                rl -> {
                    T value = reg.method_10223(rl);
                    return value == null ? defaultValue : value;
                },
                reg::method_10221);
    }


    /**
     * Like Registry::byNameCodec::listOf but won't fail for missing entries.
     * No reason to use this really, use HolderSet codec instead
     */
    public static <T> Codec<List<T>> optionalRegistryListCodec(class_2378<T> reg) {
        return class_2960.field_25139.listOf().xmap(
                l -> l.stream().filter(reg::method_10250).map(reg::method_10223).toList(),
                a -> a.stream().map(reg::method_10221).toList());
    }


    /**
     * Like listOf but won't fail for missing entries.
     */
    public static <A> LenientListCodec<A> lenientListCodec(final Codec<A> elementCodec) {
        return new LenientListCodec<>(elementCodec);
    }

    /**
     * Lenient holder set
     */
    public static <E> Codec<class_6885<E>> lenientHomogeneousList(class_5321<? extends class_2378<E>> registryKey) {
        return LenientHolderSetCodec.create(registryKey, class_6899.method_40400(registryKey), false);
    }

    public static <T extends Enum<T>> class_9139<class_2540, T> enumStreamCodec(Class<T> enumClass) {
        return new EnumStreamCodec<>(enumClass);
    }

    private record EnumStreamCodec<T extends Enum<T>>(Class<T> enumClass) implements class_9139<class_2540, T> {

        @Override
        public T decode(class_2540 buf) {
            return buf.method_10818(this.enumClass);
        }

        @Override
        public void encode(class_2540 buf, T e) {
            buf.method_10817(e);
        }
    }


    public static class_2960 idWithOptionalNamespace(String id, String namespace) {
        if (id.contains(":")) {
            return class_2960.method_60654(id);
        } else {
            return class_2960.method_60655(namespace, id);
        }
    }

    @Nullable
    public static <T> T findFirstInRegistry(class_2378<T> registry, class_2960... ids) {
        for (class_2960 r : ids) {
            var optional = registry.method_17966(r);
            if (optional.isPresent()) return optional.get();
        }
        return null;
    }

    @Nullable
    public static <T> T findFirstInRegistry(class_2378<T> registry, Iterable<class_2960> ids) {
        for (class_2960 r : ids) {
            var optional = registry.method_17966(r);
            if (optional.isPresent()) return optional.get();
        }
        return null;
    }


}