package net.mehvahdjukaar.moonlight.core.fake_player;

import com.mojang.authlib.GameProfile;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class FakeLocalPlayer extends class_742 {

    private static final boolean HAS_CACHE = PlatHelper.getPlatform().isForge(); //fabric doesnt have world unload event

    // Map of all active fake player usernames to their entities
    // automatically gets cleaned when level is unloaded as key won't be in use anymore
    private static final WeakHashMap<class_638, Map<GameProfile, FakeLocalPlayer>> FAKE_PLAYERS = new WeakHashMap<>();

    /**
     * Get a fake player with a given username,
     * Mods should either hold weak references to the return value, or listen for a
     * WorldEvent.Unload and kill all references to prevent worlds staying in memory.
     */
    static FakeLocalPlayer get(class_638 level, GameProfile username) {
        if (!HAS_CACHE) return new FakeLocalPlayer(level, username);
        return FAKE_PLAYERS.computeIfAbsent(level, l -> new HashMap<>())
                .computeIfAbsent(username, u -> new FakeLocalPlayer(level, username));
    }

    static void unloadLevel(class_1936 level) {
        FAKE_PLAYERS.entrySet().removeIf(e -> e.getKey() == level);
    }

    private final class_4048 dimensions = class_4048.method_18385(0, 0);

    public FakeLocalPlayer(class_638 pClientLevel, GameProfile pGameProfile) {
        super(pClientLevel, pGameProfile);
        this.field_5960 = true;
    }

    @Override
    public void method_5783(class_3414 pSound, float pVolume, float pPitch) {
    }

    @Override
    public @Nullable MinecraftServer method_5682() {
        return PlatHelper.getCurrentServer();
    }

    @Override
    public class_4048 method_55694(class_4050 pose) {
        return dimensions;
    }

    @Override
    public void method_5773() {
    }

    @Override
    public class_243 method_19538() {
        return new class_243(this.method_23317(), this.method_23318(), this.method_23321());
    }

    @Override
    public class_2338 method_24515() {
        return new class_2338((int) this.method_23317(), (int) this.method_23318(), (int) this.method_23321());
    }

    @Override
    public void method_36457(float pXRot) {
        super.method_36457(pXRot);
        this.field_6004 = pXRot;
    }

    @Override
    public void method_36456(float pYRot) {
        super.method_36456(pYRot);
        this.field_5982 = pYRot;
    }
}
