package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6880.class_6883;
import net.minecraft.class_7225;
import org.jetbrains.annotations.ApiStatus;

import java.util.IdentityHashMap;
import java.util.Map;

@ApiStatus.Internal
public class SoftFluidInternal {

    private static final SidedInstance<Map<class_3611, class_6880<SoftFluid>>> FLUID_MAP = SidedInstance.of(r -> {
        var m = new IdentityHashMap<class_3611, class_6880<SoftFluid>>();
        populateFluidSlaveMap(r, m);
        return m;
    });
    private static final SidedInstance<Map<class_1792, class_6880<SoftFluid>>> ITEM_MAP = SidedInstance.of(r -> {
        var m = new IdentityHashMap<class_1792, class_6880<SoftFluid>>();
        populateItemSlaveMap(r, m);
        return m;
    });


    public static class_6880<SoftFluid> fromVanillaFluid(class_3611 fluid, class_7225.class_7874 registryAccess) {
        return FLUID_MAP.get(registryAccess).get(fluid);
    }

    public static class_6880<SoftFluid> fromVanillaItem(class_1792 item, class_7225.class_7874 registryAccess) {
        return ITEM_MAP.get(registryAccess).get(item);
    }

    //needs to be called on both sides
    private static void populateFluidSlaveMap(class_7225.class_7874 registryAccess,
                                          Map<class_3611, class_6880<SoftFluid>> fluidMap) {
        fluidMap.clear();
        for (var h : SoftFluidRegistry.get(registryAccess).method_42017().toList()) {
            var s = h.comp_349();
            if (s.isEnabled()) {
                for (var eq : s.getEquivalentFluids()) {
                    class_3611 value = eq.comp_349();
                    if (value == class_3612.field_15906) {
                        Moonlight.LOGGER.error("!!Invalid fluid for fluid. This is a bug! {}", h);
                        if (PlatHelper.isDev())
                            throw new AssertionError("Invalid fluid for fluid. This is a bug! " + h);
                    }
                    fluidMap.put(value, h);
                }
                s.getEquivalentFluids().forEach(f -> fluidMap.put(f.comp_349(), h));
            }
        }
    }

    //needs to be called on both sides
    private static void populateItemSlaveMap(class_7225.class_7874 registryAccess,
                                              Map<class_1792, class_6880<SoftFluid>> itemMap) {
        itemMap.clear();
        for (var h : SoftFluidRegistry.get(registryAccess).method_42017().toList()) {
            var s = h.comp_349();
            if (s.isEnabled()) {
                s.getContainerList().getPossibleFilled().forEach(i -> {
                    //don't associate water to potion bottle
                    if (i != class_1802.field_8574 || !MLBuiltinSoftFluids.WATER.is(h)) {
                        if (i == class_1802.field_8162) {
                            Moonlight.LOGGER.error("!!Invalid item for fluid. This is a bug! {}", h);
                            if (PlatHelper.isDev())
                                throw new AssertionError("Invalid item for fluid. This is a bug! " + h);
                        }
                        itemMap.put(i, h);
                    }
                });
            }
        }
    }


    public static void init() {
        RegHelper.registerDataPackRegistry(
                SoftFluidRegistry.KEY,
                SoftFluid.CODEC,
                SoftFluid.CODEC
        );
    }

    //wtf is going on here

    //called by data sync to player
    public static void postInitClient(class_5455 ra) {
        // populate maps
        FLUID_MAP.get(ra);
        ITEM_MAP.get(ra);

        var reg = SoftFluidRegistry.get(ra);
        for (var f : reg) {
            f.afterInit();
        }
        //ok so here the extra registered fluids should have already been sent to the client
        SoftFluidColors.refreshParticleColors(reg);
    }

    public static void onDataSyncToPlayer(class_3222 player, boolean isJoined) {
        //just sends on login
        if (isJoined) {
            NetworkHelper.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    //on data load
    public static void doPostInitServer(class_5455 ra) {
        FLUID_MAP.get(ra);
        ITEM_MAP.get(ra);
        //registers existing fluids. also update the salve maps
        //we need to call this on bont server and client as this happens too late and these wont be sent
        registerExistingVanillaFluids(ra, FLUID_MAP.get(ra), ITEM_MAP.get(ra));

        for (var f : SoftFluidRegistry.get(ra)) {
            f.afterInit();
        }
    }

    @ExpectPlatform
    private static void registerExistingVanillaFluids(class_5455 ra, Map<class_3611, class_6880<SoftFluid>> fluidMap, Map<class_1792, class_6880<SoftFluid>> itemMap) {
        throw new AssertionError();
    }


}

