package net.mehvahdjukaar.moonlight.core.integration;


import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.MapCollection;
import pepjebs.mapatlases.map_collection.MapSearchKey;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.Slice;

public class MapAtlasCompat {

    public static boolean isAtlas(class_1792 item) {
        return item == MapAtlasesMod.MAP_ATLAS.get();
    }

    @Nullable
    public static class_22 getSavedDataFromAtlas(class_1799 atlas, class_1937 level, class_1657 player) {
        if(isAtlas(atlas.method_7909())) {
            MapCollection maps = MapAtlasItem.getMaps(atlas, level);
            if (maps != null) {
                Slice slice = MapAtlasItem.getSelectedSlice(atlas, level.method_27983());
                MapSearchKey key = MapSearchKey.at(maps.getScale(), player, slice);
                MapDataHolder select = maps.select(key);
                if (select != null) {
                    return select.data;
                }
            }
        }
        return null;
    }

    @Environment(EnvType.CLIENT)
    public static void scaleDecoration(class_4587 poseStack) {
        MapAtlasesClient.modifyDecorationTransform(poseStack);
    }

    @Environment(EnvType.CLIENT)
    public static void scaleDecorationText(class_4587 poseStack, float textWidth, float textScale) {
        MapAtlasesClient.modifyTextDecorationTransform(poseStack, textWidth, textScale);
    }
}
