package net.mehvahdjukaar.moonlight.core.loot;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5338;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class OptionalItemPool extends class_85 {

    public static final MapCodec<OptionalItemPool> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            Codec.STRING.fieldOf("name").forGetter(o -> o.tagOrItemId)
    ).and(method_53290(instance)).apply(instance, OptionalItemPool::new));

    @Nullable
    private final class_1792 item;
    private final String tagOrItemId;

    OptionalItemPool(String tagOrItemId, int quality, int weight, List<class_5341> lootItemConditions, List<class_117> lootItemFunctions) {
        super(quality, weight, disableIfInvalid(tagOrItemId, lootItemConditions), lootItemFunctions);
        this.item = getOptional(tagOrItemId);
        this.tagOrItemId = tagOrItemId;
    }

    @Nullable
    private static class_1792 getOptional(String res) {
        if (res.startsWith("#")) {
            class_6862<class_1792> key = class_6862.method_40092(class_7924.field_41197, class_2960.method_60654(res.substring(1)));
            //gets first valid tagged item
            for (var v : class_7923.field_41178.method_40286(key)) return v.comp_349();
            return null;
        }
        return class_7923.field_41178.method_17966(class_2960.method_60654(res)).orElse(null);
    }

    //hacky
    private static List<class_5341> disableIfInvalid(String res, List<class_5341> lootItemConditions) {
        if (getOptional(res) == null) {
            List<class_5341> newCond = new ArrayList<>();
            newCond.add(class_219.method_932(0).build()); //always false
            newCond.addAll(lootItemConditions);
            return newCond;
        }
        return lootItemConditions;
    }

    @Override
    public class_5338 method_29318() {
        return MoonlightRegistry.LAZY_ITEM.get();
    }

    @Override
    public void method_433(Consumer<class_1799> stackConsumer, class_47 lootContext) {
        if (this.item != null) {
            stackConsumer.accept(new class_1799(this.item));
        } else {
            Moonlight.LOGGER.warn("Tried to add an item from a disabled OptionalLootPoolEntry");
        }
    }

    public static class_86<?> lootTableOptionalItem(String itemRes) {
        return method_434((i, j, lootItemConditions, lootItemFunctions) -> new OptionalItemPool(itemRes, i, j, lootItemConditions, lootItemFunctions));
    }

}