package net.mehvahdjukaar.moonlight.core.map;

import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLSpecialMapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_9209;
import net.minecraft.core.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.BiFunction;
import java.util.function.Supplier;

@ApiStatus.Internal
public class MapDataInternal {

    public static final class_2378<CustomMapData.Type<?, ?>> CUSTOM_MAP_DATA_REGISTRY = RegHelper.registerRegistry(
            Moonlight.res("custom_map_data_types"), true);
    ;

    /**
     * Registers a custom data type to be stored in map data. Type will provide its onw data implementation
     **/
    public static <P, T extends CustomMapData<?, P>> CustomMapData.Type<P, T> registerCustomMapSavedData(CustomMapData.Type<P, T> type) {
        if (CUSTOM_MAP_DATA_REGISTRY.method_10250(type.id())) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + type.id());
        } else {
            RegHelper.register(type.id(), () -> type, CUSTOM_MAP_DATA_REGISTRY.method_30517());
        }
        return type;
    }

    //map markers

    public static final class_5321<class_2378<MLMapDecorationType<?, ?>>> MAP_DECORATION_REGISTRY_KEY = class_5321.method_29180(Moonlight.res("map_marker"));
    public static final class_2960 GENERIC_STRUCTURE_ID = Moonlight.res("generic_structure");
    private static final MapRegistry<Supplier<MLSpecialMapDecorationType<?, ?>>> CODE_TYPES_FACTORIES = new MapRegistry<>("code_map_decoration_types_factories");

    @Deprecated(forRemoval = true)
    public static MLMapDecorationType<?, ?> getGenericStructure() {
        return getOrDefault(GENERIC_STRUCTURE_ID);
    }

    /**
     * Call before mod setup. Register a code defined map marker type. You will still need to add a related json file
     */
    public static void registerCustomType(class_2960 id, Supplier<MLSpecialMapDecorationType<?, ?>> decorationType) {
        CODE_TYPES_FACTORIES.register(id, decorationType);
    }

    public static MLSpecialMapDecorationType<?, ?> createCustomType(class_2960 factoryID) {
        var factory = Objects.requireNonNull(CODE_TYPES_FACTORIES.getValue(factoryID),
                "No map decoration type with id: " + factoryID);
        var specialType = factory.get();
        specialType.factoryID = factoryID;
        return specialType;
    }

    @Deprecated(forRemoval = true)
    public static MLMapDecorationType<?, ?> getAssociatedType(class_6880<class_3195> structure) {
        for (var v : getValues()) {
            Optional<class_6885<class_3195>> associatedStructure = v.getAssociatedStructure();
            if (associatedStructure.isPresent() && associatedStructure.get().method_40241(structure)) {
                return v;
            }
        }
        return getGenericStructure();
    }


    public static class_6880<MLMapDecorationType<?, ?>> getDecorationFoStructure(class_1937 level, class_6880<class_3195> structure) {
        class_2378<MLMapDecorationType<?, ?>> reg = getMapDecorationRegistry(level.method_30349());
        var matched = reg.method_40270()
                .filter(
                        h -> h.comp_349().getAssociatedStructure()
                                .map(s -> s.method_40241(structure))
                                .orElse(false)
                ).findFirst();

        return matched.orElseGet(() -> reg.method_55841(GENERIC_STRUCTURE_ID).orElseThrow());
    }

    @ApiStatus.Internal
    public static void init() {
        //dumb.needed because this can be class loaded before init
        RegHelper.registerDataPackRegistry(MapDataInternal.MAP_DECORATION_REGISTRY_KEY,
                MLMapDecorationType.DIRECT_CODEC, MLMapDecorationType.DIRECT_CODEC);
    }

    @Deprecated(forRemoval = true)
    public static class_2378<MLMapDecorationType<?, ?>> hackyGetRegistry() {
        return Utils.hackyGetRegistryAccess().method_30530(MAP_DECORATION_REGISTRY_KEY);
    }


    public static class_2378<CustomMapData.Type<?, ?>> getMapDataRegistry() {
        return CUSTOM_MAP_DATA_REGISTRY;
    }

    public static class_2378<MLMapDecorationType<?, ?>> getMapDecorationRegistry(class_5455 registryAccess) {
        return registryAccess.method_30530(MAP_DECORATION_REGISTRY_KEY);
    }

    @Deprecated(forRemoval = true)
    public static class_2378<MLMapDecorationType<?, ?>> getRegistry(class_5455 registryAccess) {
        return getMapDecorationRegistry(registryAccess);
    }

    @Deprecated(forRemoval = true)
    public static Collection<MLMapDecorationType<?, ?>> getValues() {
        return hackyGetRegistry().method_10220().toList();
    }

    @Deprecated(forRemoval = true)
    public static Set<Map.Entry<class_5321<MLMapDecorationType<?, ?>>, MLMapDecorationType<?, ?>>> getEntries() {
        return hackyGetRegistry().method_29722();
    }

    @Deprecated(forRemoval = true)
    @Nullable
    public static MLMapDecorationType<? extends MLMapDecoration, ?> getOrDefault(String id) {
        return getOrDefault(class_2960.method_60654(id));
    }

    @Deprecated(forRemoval = true)
    public static MLMapDecorationType<?, ?> getOrDefault(class_2960 id) {
        var reg = hackyGetRegistry();
        var r = reg.method_10223(id);
        if (r == null) return reg.method_10223(GENERIC_STRUCTURE_ID);
        return r;
    }

    @Deprecated(forRemoval = true)
    @Nullable
    public static class_6880<MLMapDecorationType<?, ?>> getHolder(class_2960 id) {
        return hackyGetRegistry().method_55841(id).orElse(null);
    }

    @Deprecated(forRemoval = true)
    public static Optional<MLMapDecorationType<?, ?>> getOptional(class_2960 id) {
        return hackyGetRegistry().method_17966(id);
    }

    public static Set<MLMapMarker<?>> getDynamicServer(class_1657 player, class_9209 mapId, class_22 data) {
        Set<MLMapMarker<?>> dynamic = new HashSet<>();
        for (var v : DYNAMIC_SERVER) {
            dynamic.addAll(v.apply(player, mapId, data));
        }
        return dynamic;
    }

    public static Set<MLMapMarker<?>> getDynamicClient(class_9209 mapId, class_22 data) {
        Set<MLMapMarker<?>> dynamic = new HashSet<>();
        for (var v : DYNAMIC_CLIENT) {
            dynamic.addAll(v.apply(mapId, data));
        }
        return dynamic;
    }

    /**
     * returns a list of suitable world markers associated to a position. called by mixin code
     *
     * @param reader world
     * @param pos    world position
     * @return markers found, empty list if none found
     */
    public static List<MLMapMarker<?>> getMarkersFromWorld(class_1936 reader, class_2338 pos) {
        List<MLMapMarker<?>> list = new ArrayList<>();
        for (var type : getMapDecorationRegistry(reader.method_30349())) {
            MLMapMarker<?> c = type.createMarkerFromWorld(reader, pos);
            if (c != null) list.add(c);
        }
        return list;
    }

    //dynamic markers

    private static final List<TriFunction<class_1657, class_9209, class_22, Set<MLMapMarker<?>>>> DYNAMIC_SERVER = Collections.synchronizedList(new ArrayList<>());
    ;
    private static final List<BiFunction<class_9209, class_22, Set<MLMapMarker<?>>>> DYNAMIC_CLIENT = Collections.synchronizedList(new ArrayList<>());
    ;


    public static void addDynamicClientMarkersEvent(BiFunction<class_9209, class_22, Set<MLMapMarker<?>>> event) {
        DYNAMIC_CLIENT.add(event);
    }

    public static void addDynamicServerMarkersEvent(TriFunction<class_1657, class_9209, class_22, Set<MLMapMarker<?>>> event) {
        DYNAMIC_SERVER.add(event);
    }


}
