package net.mehvahdjukaar.moonlight.core.misc;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AntiRepostWarning {

    public static void run() {
        if (PlatHelper.isDev()) return;
        class_1657 player = class_310.method_1551().field_1724;
        if (player == null) return;
        Set<String> reposted = Moonlight.getDependents().stream().filter(AntiRepostWarning::isFileNameSus).collect(Collectors.toSet());

        try {
            for (var m : reposted) {
                String url = PlatHelper.getModPageUrl(m);
                if (url == null) url ="https://curseforge.com/minecraft/mc-mods";
                class_5250 link = class_2561.method_43471("message.moonlight.anti_repost_link");
                String modName = PlatHelper.getModName(m);
                class_5250 name = class_2561.method_43470(modName).method_27692(class_124.field_1067);

                class_2558 click = new class_2558(class_2558.class_2559.field_11749, url);
                link.method_10862(link.method_10866().method_10958(click).method_30938(true)
                        .method_27703(class_5251.method_27718(class_124.field_1065)));

                player.method_7353(class_2561.method_43469("message.moonlight.anti_repost", name, link), false);

            }
        } catch (Exception ignored) {
        }
    }

    private static boolean isFileNameSus(String mod) {
        var path = PlatHelper.getModFilePath(mod);
        if (path != null && path.getFileName() != null) {
            String fileName = path.getFileName().toString();
            if (fileName.contains(".jar")) {
                return fileName.contains("-Mod-") || fileName.endsWith("-tw");
            }
        }
        return false;
    }


}
