package net.mehvahdjukaar.moonlight.core.misc;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2902.class_2903;
import net.minecraft.class_3215;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6661;
import net.minecraft.class_6798;
import java.util.List;

public class CaveFilter extends class_6661 {

    public static final MapCodec<CaveFilter> CODEC =
            RecordCodecBuilder.mapCodec((instance) -> instance.group(
                            class_2902.class_2903.field_24772.listOf().fieldOf("heightmaps").forGetter((p) -> p.belowHeightMaps),
                            Codec.BOOL.fieldOf("below_sea_level").forGetter(p -> p.belowSeaLevel)
                    )
                    .apply(instance, CaveFilter::new));

    public static class Type implements class_6798<CaveFilter> {

        @Override
        public MapCodec<CaveFilter> codec() {
            return CODEC;
        }
    }

    private final List<class_2902.class_2903> belowHeightMaps;
    private final Boolean belowSeaLevel;

    private CaveFilter(List<class_2902.class_2903> types, Boolean belowSeaLevel) {
        this.belowHeightMaps = types;
        this.belowSeaLevel = belowSeaLevel;
    }


    @Override
    protected boolean method_38918(class_5444 context, class_5819 random, class_2338 pos) {
        if (context.method_34383().method_8398() instanceof class_3215 serverChunkCache) {
            int y = pos.method_10264();
            if(belowSeaLevel) {
                int sea = serverChunkCache.method_12129().method_16398();
                //below sea level
                if (y > sea) return false;
            }
            for (var h : belowHeightMaps) {
                int k = context.method_30460(h, pos.method_10263(), pos.method_10260());
                if (y > k) return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public class_6798<?> method_39615() {
        return MoonlightRegistry.CAVE_MODIFIER.get();
    }


}