package net.mehvahdjukaar.moonlight.core.misc;

import com.google.common.base.Suppliers;
import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.core.pack.DynamicResourcesInternals;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4011;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class ReloadInstanceWrapper implements class_4011 {

    public static class_4011 wrap(Supplier<class_4011> factory, class_3264 type, class_3300 manager,
                                      Executor backgroundExecutor, Collection<class_3262> selectedPacks) {
        return new ReloadInstanceWrapper(factory, type, manager, backgroundExecutor, selectedPacks);
    }

    public static void executeEarlyReloadBlocking(class_3264 type, class_3300 manager,
                                                  IProgressTracker progressTracker, Collection<class_3262> selectedPacks) {
        MoonlightEventsHelper.postEvent(new EarlyPackReloadEvent(selectedPacks, manager, type, progressTracker), EarlyPackReloadEvent.class);
    }

    private final Supplier<class_4011> lazyInstance;
    private final CompletableFuture<class_3902> beforeTask;
    private final IProgressTracker.Tree progressTracker;

    public ReloadInstanceWrapper(Supplier<class_4011> factory,
                                 class_3264 type, class_3300 manager, Executor executor,
                                 Collection<class_3262> selectedPacks) {
        this.progressTracker = IProgressTracker.createTree(1);
        this.lazyInstance = Suppliers.memoize(factory::get);
        this.beforeTask = CompletableFuture.supplyAsync(() -> {
            executeEarlyReloadBlocking(type, manager, progressTracker, selectedPacks);
            return class_3902.field_17274;
        }, executor);


    }

    @Nullable
    private class_4011 allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause() {
        if (beforeTask.isDone() && !beforeTask.isCompletedExceptionally()) {
            return lazyInstance.get();
        }
        return null;
    }

    @Override
    public CompletableFuture<?> method_18364() {
        return beforeTask.thenCompose(unused -> {
            class_4011 actual = allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause();
            return actual.method_18364();
        });
    }

    @Override
    public float method_18229() {
        float maxAmount = class_3532.method_15363(0.2f, 0, 0.5f);
        float progress = progressTracker.getProgress();
        if (!beforeTask.isDone()) {
            return progress;
        }
        class_4011 actual = allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause();
        if (actual != null) {
            return actual.method_18229() * (1);
        }
        return 1;
    }


    @Override
    public void method_18849() {
        if (!beforeTask.isDone()) {
            return;
        }
        if (beforeTask.isCompletedExceptionally()) {
            beforeTask.join(); // This will throw the exception
        }
        class_4011 actual = allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause();
        if (actual != null) {
            actual.method_18849();
        }
    }

}
