package net.mehvahdjukaar.moonlight.core.misc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.BrainAccessor;
import net.minecraft.class_1646;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4171;
import net.minecraft.class_4831;
import net.minecraft.class_7893;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class VillagerBrainEventInternal {

    private TreeMap<Integer, class_4168> scheduleBuilder = null;

    private final class_4095<class_1646> brain;
    private final class_1646 villager;

    /**
     * used to add activities, memories, sensor types and modify schedules in a compatible way
     * Main feature is easily adding scheduled activities without overriding the whole schedule and adding sensor types
     */
    public VillagerBrainEventInternal(class_4095<class_1646> brain, class_1646 villager) {
        this.brain = brain;
        this.villager = villager;
    }

    /**
     * If possible do not access the villager brain directly. The whole porpouse of this is to makde adding activities work better
     * between mods without modifying the brain directly. Use the methods below
     *
     * @return villager entity
     */
    public class_1646 getVillager() {
        return villager;
    }

    /**
     * access the brain memories to add new ones or remove existing ones
     * Important: to register a new memory types use the static method in VillagerAIManager otherwise they will not be able to be saved if you add them here manually
     *
     * @return brain memories
     */
    public Map<class_4140<?>, Optional<? extends class_4831<?>>> getMemories() {
        return brain.method_35058();
    }

    /**
     * add an activity to the brain.
     * However this isn't recommended since it doesn't completely clear its previous requirements from the requirements map. This might not be an issue tho
     * Try to use addTaskToActivity instead if you just want to add a task to an existing activity without completely overriding it
     *
     * @param activity        the identifier of the activity
     * @param activityPackage the play package itself that will be executed
     */
    public void addOrReplaceActivity(class_4168 activity, ImmutableList<? extends Pair<Integer, ? extends class_7893<? super class_1646>>> activityPackage) {
        this.brain.method_18881(activity, activityPackage);
    }


    /**
     * Adds an activity to the schedule. will override any activity that is in that specified time window
     * Note that subsequent call to this from other mods in later event execution might override your activity if the time window is the same
     * If it's not it might be shortened or cut in two
     *
     * @param activity  activity to register
     * @param startTime day time at which activity will start
     * @param endTime   day time at which activity will end. can also be less than start time
     */
    public void scheduleActivity(class_4168 activity, int startTime, int endTime) {

        if (this.scheduleBuilder == null) {
            //make default schedule builder if not initialized
            this.scheduleBuilder = this.makeDefaultSchedule(villager);
        }

        //crappy code incoming lol
        TreeMap<Integer, class_4168> newSchedule = new TreeMap<>();

        newSchedule.put(startTime, activity);

        class_4168 previousActivity = this.scheduleBuilder.lastEntry().getValue();
        for (var e : this.scheduleBuilder.entrySet()) {
            int key = e.getKey();
            if (key < endTime) {
                previousActivity = e.getValue();
            }
            //only adds if in correct time window
            if (startTime < endTime) {
                if (key < startTime || key > endTime) {
                    newSchedule.put(key, e.getValue());
                }
            } else {
                if (key > endTime && key < startTime) {
                    newSchedule.put(key, e.getValue());
                }
            }
        }
        newSchedule.put(endTime, previousActivity);

        this.scheduleBuilder = newSchedule;
    }


    //this might be bad

    /**
     * Adds a sensor to the villager
     *
     * @param newSensor sensor to be added
     */
    public void addSensor(class_4149<? extends class_4148<class_1646>> newSensor) {

        try {
            Map<class_4149<? extends class_4148<class_1646>>, class_4148<class_1646>> sensors = ((BrainAccessor) brain).getSensors();

            var sensorInstance = newSensor.method_19102();
            sensors.put(newSensor, sensorInstance);

            var memories = this.brain.method_35058();

            for (class_4140<?> memoryModuleType : sensorInstance.method_19099()) {
                memories.put(memoryModuleType, Optional.empty());
            }
        } catch (Exception e) {
            Moonlight.LOGGER.warn("failed to register pumpkin sensor type for villagers: " + e);
        }
    }


    /**
     * Used to add a single task to an existing activity. Useful so you can add to existing activities without overriding or having to override the entire activity.
     * Alternatively you can define your own activity and add it to the villager schedule using scheduleActivity
     *
     * @param activity activity you want to add a task to
     * @param task     task to add with its priority
     * @return if successfull
     */
    public   <P extends Pair<Integer, ? extends class_4097<class_1646>>> boolean addTaskToActivity(class_4168 activity, P task) {

        try {
            Map<Integer, Map<class_4168, Set<class_4097<class_1646>>>> map =
                    (Map<Integer, Map<class_4168, Set<class_4097<class_1646>>>>) ((BrainAccessor) brain).getAvailableBehaviorsByPriority();

            var tasksWithSamePriority = map.computeIfAbsent(task.getFirst(), (m) -> Maps.newHashMap());

            var activityTaskSet = tasksWithSamePriority.computeIfAbsent(activity, (a) -> Sets.newLinkedHashSet());

            activityTaskSet.add(task.getSecond());

            return true;

        } catch (Exception e) {
            Moonlight.LOGGER.warn("failed to add task for activity {} for villagers: {}", activity, e);
        }
        return false;
    }


    private TreeMap<Integer, class_4168> makeDefaultSchedule(class_1646 villager) {
        TreeMap<Integer, class_4168> map = new TreeMap<>();
        //mimics vanilla behavior until I figure out how to decode a compiled schedule
        if (villager.method_6109()) {
            map.put(10, class_4168.field_18595);
            map.put(3000, class_4168.field_18885);
            map.put(6000, class_4168.field_18595);
            map.put(10000, class_4168.field_18885);
            map.put(12000, class_4168.field_18597);
        } else {

            map.put(10, class_4168.field_18595);
            map.put(2000, class_4168.field_18596);
            map.put(9000, class_4168.field_18598);
            map.put(11000, class_4168.field_18595);
            map.put(12000, class_4168.field_18597);
        }
        return map;
    }

    class_4170 buildFinalizedSchedule() {
        class_4171 builder = new class_4171(MoonlightRegistry.CUSTOM_VILLAGER_SCHEDULE.get());
        for (var e : this.scheduleBuilder.entrySet()) {
            builder.method_19221(e.getKey(), e.getValue());
        }
        return builder.method_19220();
    }

    boolean hasCustomSchedule() {
        return this.scheduleBuilder != null;
    }

}
