package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedItem;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1747.class)
public abstract class BlockItemMixin extends class_1792 implements IExtendedItem {

    protected BlockItemMixin(class_1793 pProperties) {
        super(pProperties);
    }

    @Inject(method = "getPlacementState", at = @At("HEAD"), cancellable = true)
    private void moonlight$getPlacementState(class_1750 pContext, CallbackInfoReturnable<class_2680> cir) {
        AdditionalItemPlacement behavior = this.moonlight$getAdditionalBehavior();
        if (behavior != null) {
            class_2680 overrideBlockState = behavior.overrideGetPlacementState(pContext);
            if (overrideBlockState != null ) {
                cir.setReturnValue(overrideBlockState);
            }
        }
    }

    @Inject(method = "place", at = @At("HEAD"), cancellable = true)
    private void moonlight$place(class_1750 pContext, CallbackInfoReturnable<class_1269> cir) {
        AdditionalItemPlacement behavior = this.moonlight$getAdditionalBehavior();
        if (behavior != null) {
            var result = behavior.overridePlace(pContext);
            if (result.method_23665()) {
                cir.setReturnValue(result);
            }
        }
    }

    @Inject(method = "updatePlacementContext", at = @At("HEAD"), cancellable = true)
    private void moonlight$updatePlacementContext(class_1750 pContext, CallbackInfoReturnable<class_1750> cir) {
        AdditionalItemPlacement behavior = this.moonlight$getAdditionalBehavior();
        if (behavior != null) {
            var result = behavior.overrideUpdatePlacementContext(pContext);
            if(result != null){
                cir.setReturnValue(result);
            }
        }
    }

}
