package net.mehvahdjukaar.moonlight.core.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.TextureUtil;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_8215;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.nio.file.Path;

@Mixin(class_1043.class)
public abstract class DynamicTextureMixin extends class_1044 implements class_8215 {

    @Shadow
    private class_1011 pixels;

    @WrapOperation(method = "upload", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/NativeImage;upload(IIIZ)V"))
    public void forceMipMap(class_1011 instance, int a, int b, int c, boolean autoClose, Operation<Void> op) {
        if (MoonlightClient.isMapMipMap()) {
            this.field_5203 = true;
            instance.method_22619(a, b, c, 0, 0, instance.method_4307(), instance.method_4323(),
                    false, true, true, autoClose);
            //GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL11.GL_TRUE);
            if(!autoClose) GL30.glGenerateMipmap(GL11.GL_TEXTURE_2D);
        } else op.call(instance, a, b, c, autoClose);
    }

    @WrapOperation(method = "<init>(IIZ)V", at = @At(value = "INVOKE",
            target = "Lcom/mojang/blaze3d/platform/TextureUtil;prepareImage(III)V"))
    public void forceMipMap(int a, int b, int c, Operation<Void> op) {
        if (MoonlightClient.isMapMipMap()) {
            this.field_5203 = true;
            TextureUtil.prepareImage(a, ClientConfigs.MAPS_MIPMAP.get(), b, c);
        } else op.call(a, b, c);

    }

    /**
     * @author MehVahdJukaar
     * @reason proper mipmap
     */
    @Overwrite
    public void method_49712(class_2960 pResourceLocation, Path pPath) {
        if (this.pixels != null) {
            String s = pResourceLocation.method_36181();
            TextureUtil.writeAsPNG(pPath, s, this.method_4624(), this.field_5203 ? ClientConfigs.MAPS_MIPMAP.get() : 0, this.pixels.method_4307(), this.pixels.method_4323());
        }
    }
}
