package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.events.ILightningStruckBlockEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1538.class)
public abstract class LightningEntityMixin extends class_1297 {

    @Shadow
    protected abstract class_2338 getStrikePosition();

    protected LightningEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }


    @Inject(method = "powerLightningRod", at = @At("HEAD"))
    private void powerLightningRod(CallbackInfo ci) {
        class_2338 blockPos = this.getStrikePosition();
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        var event = ILightningStruckBlockEvent.create(blockState, method_37908(), blockPos, (class_1538) (Object) this);
        MoonlightEventsHelper.postEvent(event, ILightningStruckBlockEvent.class);
    }
}
