package net.mehvahdjukaar.moonlight.core.mixins;

import com.google.common.collect.Maps;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData.Type;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MLMapDecorationsComponent;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IHoldingPlayerExtension;
import net.minecraft.class_1657;
import net.minecraft.class_17;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.*;
import java.util.Map.Entry;
import java.util.function.Consumer;


@Mixin(class_22.class)
public abstract class MapDataMixin extends class_18 implements ExpandedMapData {

    @Final
    @Shadow
    public byte scale;

    @Final
    @Shadow
    Map<String, net.minecraft.class_20> decorations;

    @Shadow
    @Final
    private Map<String, class_17> bannerMarkers;

    @Shadow
    public int centerX;
    @Shadow
    public int centerZ;

    @Shadow
    @Final
    private List<class_22.class_23> carriedBy;
    //new decorations (stuff that gets rendered)
    @Unique
    public Map<String, MLMapDecoration> moonlight$customDecorations = Maps.newLinkedHashMap();

    //world markers (stuff that gets saved)
    @Unique
    private final Map<String, MLMapMarker<?>> moonlight$customMapMarkers = Maps.newHashMap();

    //custom data that can be stored in maps
    @Unique
    public final Map<CustomMapData.Type<?,?>, CustomMapData<?,?>> moonlight$customData = new LinkedHashMap<>();

    @Override
    public void ml$setCustomDecorationsDirty() {
        this.method_80();
        carriedBy.forEach(h -> ((IHoldingPlayerExtension) h).moonlight$setCustomMarkersDirty());
    }

    @Override
    public <H extends CustomMapData.DirtyCounter> void ml$setCustomDataDirty(
            CustomMapData.Type<?,?> type, Consumer<H> dirtySetter) {
        this.method_80();
        carriedBy.forEach(h -> ((IHoldingPlayerExtension) h)
                .moonlight$setCustomDataDirty(type, dirtySetter));

    }

    @Override
    public Map<CustomMapData.Type<?,?>, CustomMapData<?,?>> ml$getCustomData() {
        return moonlight$customData;
    }

    @Override
    public Map<String, MLMapDecoration> ml$getCustomDecorations() {
        return moonlight$customDecorations;
    }

    @Override
    public Map<String, MLMapMarker<?>> ml$getCustomMarkers() {
        return moonlight$customMapMarkers;
    }

    @Override
    public int ml$getVanillaDecorationSize() {
        return this.decorations.size();
    }

    @Override
    public <M extends MLMapMarker<?>> void ml$addCustomMarker(M marker) {
        var decoration = marker.createDecorationFromMarker((class_22) (Object) this);
        if (decoration != null) {
            this.moonlight$customDecorations.put(marker.getMarkerUniqueId(), decoration);
            if (marker.shouldSave()) {
                this.moonlight$customMapMarkers.put(marker.getMarkerUniqueId(), marker);
            }
            //so packet is sent
            ml$setCustomDecorationsDirty();
        }
    }

    @Override
    public boolean ml$removeCustomMarker(String key) {
        moonlight$customDecorations.remove(key);
        if (moonlight$customMapMarkers.containsKey(key)) {
            moonlight$customMapMarkers.remove(key);
            ml$setCustomDecorationsDirty();
            return true;
        }
        return false;
    }

    @Override
    public class_22 ml$copy() {
        class_22 newData = class_22.method_32371(this.method_75(
                new class_2487(), Utils.hackyGetRegistryAccess()), Utils.hackyGetRegistryAccess());
        newData.method_80();
        return newData;
    }

    @Override
    public void ml$resetCustomDecoration() {
        if (!bannerMarkers.isEmpty() || !moonlight$customMapMarkers.isEmpty()) {
            ml$setCustomDecorationsDirty();
        }
        for (String key : this.moonlight$customMapMarkers.keySet()) {
            this.moonlight$customDecorations.remove(key);
        }
        this.moonlight$customMapMarkers.clear();
        for (String key : this.bannerMarkers.keySet()) {
            this.decorations.remove(key);
        }
        this.bannerMarkers.clear();
    }

    /**
     * @param world level
     * @param pos   world position where a marker providing block could be
     * @return true if a marker was toggled
     */
    @Override
    public boolean ml$toggleCustomDecoration(class_1936 world, class_2338 pos) {
        if (world.method_8608()) {
            List<MLMapMarker<?>> markers = MapDataInternal.getMarkersFromWorld(world, pos);
            return !markers.isEmpty();
        }

        double d0 = pos.method_10263() + 0.5D;
        double d1 = pos.method_10260() + 0.5D;
        int i = 1 << this.scale;
        double d2 = (d0 - this.centerX) / i;
        double d3 = (d1 - this.centerZ) / i;
        if (d2 >= -63.0D && d3 >= -63.0D && d2 <= 63.0D && d3 <= 63.0D) {
            List<MLMapMarker<?>> markers = MapDataInternal.getMarkersFromWorld(world, pos);

            boolean changed = false;
            for (MLMapMarker<?> marker : markers) {
                if (marker != null) {
                    //toggle
                    String id = marker.getMarkerUniqueId();
                    if (marker.equals(this.moonlight$customMapMarkers.get(id))) {
                        ml$removeCustomMarker(id);
                    } else {
                        this.ml$addCustomMarker(marker);
                    }
                    changed = true;
                }
            }
            return changed;
        }
        return false;
    }


    @Inject(method = "locked", at = @At("RETURN"))
    public void locked(CallbackInfoReturnable<class_22> cir) {
        class_22 data = cir.getReturnValue();
        if (data instanceof ExpandedMapData expandedMapData) {
            expandedMapData.ml$getCustomMarkers().putAll(this.ml$getCustomMarkers());
            expandedMapData.ml$getCustomDecorations().putAll(this.ml$getCustomDecorations());
        }
        moonlight$copyCustomData(data, false, Utils.hackyGetRegistryAccess());
    }

    @Inject(method = "scaled", at = @At("RETURN"))
    public void scaled(CallbackInfoReturnable<class_22> cir) {
        class_22 data = cir.getReturnValue();
        moonlight$copyCustomData(data, true, Utils.hackyGetRegistryAccess());
    }

    @Unique
    private void moonlight$copyCustomData(class_22 data, boolean isScaled, class_7225.class_7874 reg) {
        if (data instanceof ExpandedMapData ed) {
            for (var entry : this.moonlight$customData.entrySet()) {
                CustomMapData<?,?> customData = entry.getValue();
                boolean persists = isScaled ? customData.persistOnRescale() : customData.persistOnCopyOrLock();
                if (persists) {
                    class_2487 t = new class_2487();
                    customData.save(t, reg);
                    ed.ml$getCustomData().get(entry.getKey()).load(t, reg);
                }
            }
        }
    }


    @Inject(method = "tickCarriedBy", at = @At("TAIL"))
    public void tickCarriedBy(class_1657 player, class_1799 stack, CallbackInfo ci) {
        //for exploration maps. Decoration assigned to an item instead of a map directly
        MLMapDecorationsComponent customDecoComponent = stack.method_57824(MoonlightRegistry.CUSTOM_MAP_DECORATIONS.get());
        if (customDecoComponent != null) {
            customDecoComponent.addToMapIfAbsent(this.moonlight$customMapMarkers.keySet(), this);
        }
    }


    @Inject(method = "load", at = @At("RETURN"))
    private static void load(class_2487 compound, class_7225.class_7874
            registries, CallbackInfoReturnable<class_22> cir) {
        class_22 data = cir.getReturnValue();
        if (compound.method_10545("customMarkers") && data instanceof ExpandedMapData mapData) {
            class_2499 listNBT = compound.method_10554("customMarkers", 10);

            class_6903<class_2520> registryOps = registries.method_57093(class_2509.field_11560);

            for (int j = 0; j < listNBT.size(); ++j) {
                MLMapMarker.REFERENCE_CODEC.parse(registryOps, listNBT.method_10602(j))
                        .resultOrPartial(string -> Moonlight.LOGGER.warn("Failed to parse moonlight map marker: '{}'", string))
                        .ifPresent(marker -> {
                            mapData.ml$getCustomMarkers().put(marker.getMarkerUniqueId(), marker);
                            mapData.ml$addCustomMarker(marker);
                        });
            }

            mapData.ml$getCustomData().values().forEach(customMapData -> customMapData.load(compound, registries));
        }
    }

    @Inject(method = "save", at = @At("RETURN"))
    public void save(class_2487 tag, class_7225.class_7874 registries, CallbackInfoReturnable<class_2487> cir) {
        class_2487 com = cir.getReturnValue();

        class_2499 listNBT = new class_2499();

        class_6903<class_2520> registryOps = registries.method_57093(class_2509.field_11560);

        for (MLMapMarker<?> marker : this.moonlight$customMapMarkers.values()) {
            if (marker.shouldSave()) {
                listNBT.add(MLMapMarker.REFERENCE_CODEC.encodeStart(registryOps, marker).getOrThrow());
            }
        }
        com.method_10566("customMarkers", listNBT);

        this.moonlight$customData.forEach((s, o) -> o.save(tag, registries));

    }

    @Inject(method = "checkBanners", at = @At("TAIL"))
    public void checkCustomDeco(class_1922 world, int x, int z, CallbackInfo ci) {
        List<String> toRemove = new ArrayList<>();
        List<MLMapMarker<?>> toAdd = new ArrayList<>();
        for (var e : this.moonlight$customMapMarkers.entrySet()) {
            var marker = e.getValue();
            if (marker.getPos().method_10263() == x && marker.getPos().method_10260() == z) {
                if (marker.shouldRefreshFromWorld()) {
                    MLMapMarker<?> newMarker = marker.getType().comp_349().createMarkerFromWorld(world, marker.getPos());
                    String id = e.getKey();
                    if (newMarker == null) {
                        toRemove.add(id);
                    } else if (!Objects.equals(marker, newMarker)) {
                        toRemove.add(id);
                        toAdd.add(newMarker);
                    }
                }
            }
        }
        toRemove.forEach(this::ml$removeCustomMarker);
        toAdd.forEach(this::ml$addCustomMarker);
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    public void initCustomData(int i, int j, byte b, boolean bl, boolean bl2, boolean bl3,
                               class_5321<class_1937> resourceKey, CallbackInfo ci) {
        for (var d : MapDataInternal.getMapDataRegistry()) {
            moonlight$customData.put(d, d.factory().get());
        }
    }

    @ModifyReturnValue(method = "isExplorationMap", at = @At("RETURN"))
    public boolean ml$isExplorationMap(boolean original) {
        if (original) return true;
        for (var mapDecoration : this.moonlight$customMapMarkers.values()) {
            if (mapDecoration.preventsExtending()) {
                return true;
            }
        }
        return false;
    }
}
