package net.mehvahdjukaar.moonlight.core.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

// All require 0 because of Optishit. I should have not given in...
@Mixin(targets = "net/minecraft/client/gui/MapRenderer$MapInstance", priority = 900)
public abstract class MapInstanceMixin {


    @WrapOperation(method = "updateTexture",
            require = 0,
            at = @At(value = "INVOKE",
            target = "Lnet/minecraft/client/renderer/texture/DynamicTexture;upload()V"))
    public void forceMipMap(class_1043 instance, Operation<Void> op) {
        MoonlightClient.setMipMap(true);
        op.call(instance);
        MoonlightClient.setMipMap(false);
    }

    @WrapOperation(
            method = {"<init>"},
            require = 0,
            at = {@At(
                    value = "NEW",
                    target ="(IIZ)Lnet/minecraft/client/renderer/texture/DynamicTexture;",
                    remap = false
            )}
    )
    private class_1043 forceMipMapOn(int width, int height, boolean useCalloc, Operation<class_1043> original) {
        MoonlightClient.setMipMap(true);
        var t = original.call(width, height, useCalloc);
        MoonlightClient.setMipMap(false);
        return t;
    }

    @WrapOperation(method = "<init>",
            require = 0,
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/RenderType;text(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/RenderType;"))
    private class_1921 getTextMipMap(class_2960 pLocation, Operation<class_1921> op) {
        if (ClientConfigs.MAPS_MIPMAP.get() != 0) {
            return RenderUtil.getTextMipmapRenderType(pLocation);
        } else return op.call(pLocation);
    }
}
