package net.mehvahdjukaar.moonlight.core.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData.DirtyDataPatch;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2683;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9209;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

//I hope this won't break with mods. We need this as all data needs to be received at the same time
@Mixin(class_2683.class)
public abstract class MapItemDataPacketMixin implements IMapDataPacketExtension {

    @Shadow
    @Final
    private class_9209 mapId;

    @Nullable
    @Unique
    private List<MLMapDecoration> moonlight$customDecorations = null;
    @Nullable
    @Unique
    private List<CustomMapData.DirtyDataPatch<?, ?>> moonlight$customDataPatches = null;
    @Unique
    private int moonlight$mapCenterX = 0;
    @Unique
    private int moonlight$mapCenterZ = 0;
    @Unique
    private class_2960 moonlight$dimension = class_1937.field_25179.method_29177();

    //new constructor expansion
    @Inject(method = "<init>(Lnet/minecraft/world/level/saveddata/maps/MapId;BZLjava/util/Optional;Ljava/util/Optional;)V",
            at = @At("RETURN"))
    private void moonlight$addExtraCenterAndDimension(class_9209 mapId, byte b, boolean bl, Optional optional, Optional optional2, CallbackInfo ci) {
        var server = PlatHelper.getCurrentServer();
        // on server side we add extra data like this
        if (server != null && server.method_30002() instanceof class_3218 sl) {
            class_22 data = sl.method_17891(mapId);
            //we are assuming here that this packet i FOR the vanilla map. we'll need to add additional constructor logic to se these for another mod map in a mixin... I dont see a way around this, we are missing information
            if (data != null) {
                this.moonlight$mapCenterX = data.field_116;
                this.moonlight$mapCenterZ = data.field_115;
                this.moonlight$dimension = data.field_118.method_29177();
            }
        }
    }

    @ModifyExpressionValue(method = "<clinit>", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/network/codec/StreamCodec;composite(Lnet/minecraft/network/codec/StreamCodec;Ljava/util/function/Function;Lnet/minecraft/network/codec/StreamCodec;Ljava/util/function/Function;Lnet/minecraft/network/codec/StreamCodec;Ljava/util/function/Function;Lnet/minecraft/network/codec/StreamCodec;Ljava/util/function/Function;Lnet/minecraft/network/codec/StreamCodec;Ljava/util/function/Function;Lcom/mojang/datafixers/util/Function5;)Lnet/minecraft/network/codec/StreamCodec;"))
    private static class_9139<class_9129, class_2683> moonlight$modifyMapPacketCodec(
            class_9139<class_9129, class_2683> original) {
        return class_9139.method_58025(original, Function.identity(),
                MLMapDecoration.CODEC.method_56433(class_9135.method_56363()).method_56433(class_9135::method_56382),
                p -> ((IMapDataPacketExtension) (Object) p).moonlight$getCustomDecorations(),
                CustomMapData.DirtyDataPatch.STREAM_CODEC.method_56433(class_9135.method_56363()).method_56433(class_9135::method_56382),
                p -> ((IMapDataPacketExtension) (Object) p).moonlight$getDirtyCustomData(),
                class_2960.field_48267, p -> ((IMapDataPacketExtension) (Object) p).moonlight$getDimension(),
                class_9135.field_49675, p -> ((IMapDataPacketExtension) (Object) p).moonlight$getMapCenterX(),
                class_9135.field_49675, p -> ((IMapDataPacketExtension) (Object) p).moonlight$getMapCenterZ(),
                (old, deco, dataPatch, res, x, z) -> {
                    if (old == null) {
                        return null;
                    }
                    IMapDataPacketExtension ext = (IMapDataPacketExtension) (Object) old;
                    ext.moonlight$setCustomDecorations(deco);
                    ext.moonlight$setDirtyCustomData(dataPatch);
                    ext.moonlight$setDimension(res);
                    ext.moonlight$setMapCenter(x, z);
                    return old;
                }
        );
    }

    @Override
    public Optional<List<CustomMapData.DirtyDataPatch<?, ?>>> moonlight$getDirtyCustomData() {
        return Optional.ofNullable(moonlight$customDataPatches);
    }

    @Override
    public Optional<List<MLMapDecoration>> moonlight$getCustomDecorations() {
        return Optional.ofNullable(moonlight$customDecorations);
    }

    @Override
    public void moonlight$setCustomDecorations(Optional<List<MLMapDecoration>> deco) {
        moonlight$customDecorations = deco.map(List::copyOf).orElse(null);
    }

    @Override
    public void moonlight$setDirtyCustomData(Optional<List<CustomMapData.DirtyDataPatch<?, ?>>> tag) {
        moonlight$customDataPatches = tag.map(List::copyOf).orElse(null);
    }

    @NotNull
    @Override
    public class_2960 moonlight$getDimension() {
        return moonlight$dimension;
    }

    @Override
    public void moonlight$setDimension(class_2960 dim) {
        this.moonlight$dimension = dim;
    }

    @Override
    public int moonlight$getMapCenterX() {
        return this.moonlight$mapCenterX;
    }

    @Override
    public int moonlight$getMapCenterZ() {
        return this.moonlight$mapCenterZ;
    }

    @Override
    public void moonlight$setMapCenter(int x, int z) {
        this.moonlight$mapCenterX = x;
        this.moonlight$mapCenterZ = z;
    }

    @Inject(method = "applyToMap", at = @At("HEAD"))
    private void handleExtraData(class_22 mapData, CallbackInfo ci) {
        var serverDeco = this.moonlight$customDecorations;
        var serverDataPatches = this.moonlight$customDataPatches;

        mapData.field_116 = this.moonlight$mapCenterX;
        mapData.field_115 = this.moonlight$mapCenterZ;
        mapData.field_118 = class_5321.method_29179(class_7924.field_41223, this.moonlight$dimension);


        if (mapData instanceof ExpandedMapData ed) {
            Map<String, MLMapDecoration> decorations = ed.ml$getCustomDecorations();


            //mapData = MapItemSavedData.createForClient(message.scale, message.locked, Minecraft.getInstance().level.dimension());
            //Minecraft.getInstance().level.setMapData(string, mapData);

            if (serverDeco != null) {
                decorations.clear();
                int i;
                for (i = 0; i < serverDeco.size(); ++i) {
                    MLMapDecoration customDecoration = serverDeco.get(i);
                    if (customDecoration != null) decorations.put("icon-" + i, customDecoration);
                    else {
                        Moonlight.LOGGER.warn("Failed to load custom map decoration, skipping");
                    }
                }

            }
            if (serverDataPatches != null) {
                for (var p : serverDataPatches) {
                    var customData = ed.ml$getCustomData();
                    p.apply(customData);
                }

            }

            //adds dynamic todo use deco instead
            // aaa not optimal but needed for player like behavior
            // update immediately all the times
            for (MLMapMarker<?> m : MapDataInternal.getDynamicClient(mapId, mapData)) {
                var d = m.createDecorationFromMarker(mapData);
                if (d != null) {
                    decorations.put(m.getMarkerUniqueId(), d);
                }
            }
        }
    }

}
