package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;


@Mixin(class_1806.class)
public abstract class MapItemMixin {

    //since I'm here might aswell mixin instead of event
    @Inject(method = "appendHoverText", at = @At("HEAD"))
    private void appendHoverText(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag, CallbackInfo ci) {
        class_9209 mapId = stack.method_57824(class_9334.field_49646);
        class_22 mapData = context.method_59529(mapId);
        if (mapData instanceof ExpandedMapData data) {
            data.ml$getCustomData().forEach((s, o) -> {
                class_2561 c = o.onItemTooltip(mapData, stack);
                if (c != null) tooltipComponents.add(c);
            });
        }
    }

    @Inject(method = "update", at = @At("HEAD"), cancellable = true)
    private void update(class_1937 level, class_1297 entity, class_22 data, CallbackInfo ci) {
        AtomicBoolean b = new AtomicBoolean(false);
        if (data instanceof ExpandedMapData d) {
            d.ml$getCustomData().forEach((s, o) -> {
                if (o.onItemUpdate(data, entity)) b.set(true);
            });
        }
        if (b.get()) ci.cancel();
    }


}
