package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.item.ILeftClickReact;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.network.ServerBoundItemLeftClickPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_310.class)
public abstract class MinecraftMixin {

    @Shadow
    @Nullable
    public class_746 player;

    //cancel rope slide down sound
    @Inject(method = "startAttack", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;",
            shift = At.Shift.BEFORE), cancellable = true)
    private void moonlight$onItemLeftClick(CallbackInfoReturnable<Boolean> cir) {
        class_1268 hand = class_1268.field_5808;
        class_1799 stack = this.player.method_5998(hand);
        if (stack.method_7909() instanceof ILeftClickReact lr) {
            boolean cancel = lr.onLeftClick(stack, this.player, hand);
            NetworkHelper.sendToServer(new ServerBoundItemLeftClickPacket(hand));
            if (cancel) {
                this.player.method_6104(class_1268.field_5808);
                cir.setReturnValue(false);
            }
        }
    }

}
