package net.mehvahdjukaar.moonlight.core.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.DataFixer;
import net.mehvahdjukaar.moonlight.api.misc.fake_level.FakeServerLevel;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_32;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3695;
import net.minecraft.class_3949;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5567;
import net.minecraft.class_5571;
import net.minecraft.class_5576;
import net.minecraft.class_5579;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.concurrent.Executor;
import java.util.function.Supplier;

@Mixin(class_3218.class)
public abstract class ServerLevelMixin extends class_1937 {

    protected ServerLevelMixin(class_5269 levelData, class_5321<class_1937> dimension, class_5455 registryAccess, class_6880<class_2874> dimensionTypeRegistration, Supplier<class_3695> profiler, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, profiler, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @WrapOperation(method = "<init>", at = @At(value = "NEW", target = "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lcom/mojang/datafixers/DataFixer;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplateManager;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/chunk/ChunkGenerator;IIZLnet/minecraft/server/level/progress/ChunkProgressListener;Lnet/minecraft/world/level/entity/ChunkStatusUpdateListener;Ljava/util/function/Supplier;)Lnet/minecraft/server/level/ServerChunkCache;"))
    private class_3215 ml$assignFakeChunkCache(class_3218 level, class_32.class_5143 levelStorageAccess,
                                                DataFixer fixerUpper, class_3485 structureManager,
                                                Executor dispatcher, class_2794 generator, int viewDistance,
                                                int simulationDistance, boolean sync, class_3949 progressListener,
                                                class_5567 chunkStatusListener,
                                                Supplier<class_26> dataStorage,
                                                Operation<class_3215> operation) {
        if ((Object) this instanceof FakeServerLevel) {
            return FakeServerLevel.createDummyChunkCache(level, levelStorageAccess, fixerUpper, structureManager, dispatcher, generator, viewDistance, simulationDistance, sync, progressListener, chunkStatusListener, dataStorage);
        }
        return operation.call(level, levelStorageAccess, fixerUpper, structureManager, dispatcher, generator, viewDistance, simulationDistance, sync, progressListener, chunkStatusListener, dataStorage);
    }

    @WrapOperation(method = "<init>", at = @At(value = "NEW", target = "(Ljava/lang/Class;Lnet/minecraft/world/level/entity/LevelCallback;Lnet/minecraft/world/level/entity/EntityPersistentStorage;)Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;"))
    private class_5579<?> ml$assignFakePersistentEntitySectionManager(
            Class entityClass, class_5576 callbacks, class_5571 permanentStorage,
            Operation<class_5579> original) {
        if ((Object) this instanceof FakeServerLevel) {
            return FakeServerLevel.createDummyEntityManager(entityClass, callbacks, permanentStorage);
        }
        return original.call(entityClass, callbacks, permanentStorage);
    }
}
