package net.mehvahdjukaar.moonlight.core.mixins.fabric;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.mehvahdjukaar.moonlight.api.client.model.fabric.MLFabricModelLoaderRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_793;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.lang.reflect.Type;

@Mixin(class_793.class_795.class)
public abstract class BlockModelDeserializerMixin {

    @ModifyReturnValue(method = "deserialize(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnet/minecraft/client/renderer/block/model/BlockModel;",
            at = @At("RETURN"))
    public class_793 deserialize(class_793 original, JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonobject = element.getAsJsonObject();
        if (jsonobject.has("loader")) {
            class_2960 loader = class_2960.method_60654(class_3518.method_15265(jsonobject, "loader"));
            class_793 custom = MLFabricModelLoaderRegistry.getUnbakedModel(
                    loader, context, jsonobject, original);
            if (custom != null) return custom;
        }
        return original;
    }
}
