package net.mehvahdjukaar.moonlight.core.mixins.fabric;

import net.mehvahdjukaar.moonlight.api.client.model.CustomGeometry;
import net.mehvahdjukaar.moonlight.api.client.model.fabric.BlockModelWithCustomGeo;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Function;

@Mixin(class_793.class)
public class BlockModelMixin {

    // makes models with a custom parent loader also use its geometry baking
    @Inject(at = @At("HEAD"), cancellable = true,
            method = "bake(Lnet/minecraft/client/resources/model/ModelBaker;Lnet/minecraft/client/renderer/block/model/BlockModel;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Z)Lnet/minecraft/client/resources/model/BakedModel;")
    void moonlight$bakeCustomGeo(class_7775 baker, class_793 model, Function<class_4730, class_1058> spriteGetter,
                                 class_3665 state, boolean guiLight3d,
                                 CallbackInfoReturnable<class_1087> cir) {
        CustomGeometry geo = getParentGeoRecursive(model);
        if (geo != null) {
            cir.setReturnValue(geo.bake(baker, spriteGetter, state));
        }
    }

    @Unique
    private static CustomGeometry getParentGeoRecursive(class_793 model) {
        if (model != null) {
            if (model instanceof BlockModelWithCustomGeo w) {
                return w.getCustomGeometry();
            }
            return getParentGeoRecursive(model.field_4253);
        }
        return null;
    }


}
