package net.mehvahdjukaar.moonlight.core.mixins.fabric;

import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.fabric.ModelWrapper;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;

import java.util.function.Supplier;

@Mixin(CustomBakedModel.class)
public interface SelfCustomBakedModel extends FabricBakedModel, CustomBakedModel, class_1087 {

    @Override
    default boolean isVanillaAdapter() {
        return false;
    }

    @Override
    default void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        // Object attachment = ((RenderAttachedBlockView)blockView).getBlockEntityRenderAttachment(pos);
        var tile = blockView.method_8321(pos);
        ExtraModelData data = ExtraModelData.EMPTY;
        if (tile instanceof IExtraModelDataProvider provider) {
            //SlaveModel inner = SlaveModel.INSTANCE;
            //creating a new instance because indium doesn't like it...
            data = provider.getExtraModelData();
        }

        ModelWrapper inner = new ModelWrapper(this, getModelData(data, pos, state, blockView));
        inner.emitBlockQuads(blockView, state, pos, randomSupplier, context);
    }

    @Override
    default void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        // Object attachment = ((RenderAttachedBlockView)blockView).getBlockEntityRenderAttachment(pos);
        ExtraModelData data = ExtraModelData.EMPTY;

        ModelWrapper inner = new ModelWrapper(this, getModelData(data, stack));
        inner.emitItemQuads(stack,randomSupplier, context );
    }




}
