package net.mehvahdjukaar.moonlight.core.network;

import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;


public class ClientBoundOpenScreenPacket implements Message {

    public static final class_9155<class_9129, ClientBoundOpenScreenPacket> TYPE = Message.makeType(
            Moonlight.res("s2c_open_screen"), ClientBoundOpenScreenPacket::new);

    public final TileOrEntityTarget target;
    private final class_2350 dir;

    public ClientBoundOpenScreenPacket(class_9129 buffer) {
        this.target = TileOrEntityTarget.read(buffer);
        this.dir = class_2350.method_10143(buffer.method_10816());
    }

    public ClientBoundOpenScreenPacket(TileOrEntityTarget target,@Nullable class_2350 hitFace) {
        this.target = target;
        this.dir = hitFace == null ? class_2350.field_11036 : hitFace;
    }

    @Override
    public void write(class_9129 buffer) {
        this.target.write(buffer);
        buffer.method_10804(this.dir.method_10146());
    }

    @Override
    public void handle(Context context) {
        class_1657 player = context.getPlayer();
        class_1937 level = player.method_37908();

        if (this.target.getTarget(level) instanceof IScreenProvider tile) {
            tile.openScreen(level, player, this.dir);
        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE.comp_2243();
    }
}