package net.mehvahdjukaar.moonlight.core.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_6019;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import net.minecraft.class_9129;

public class ClientBoundParticleAroundBlockPacket implements Message {

    public static final class_9155<class_9129, ClientBoundParticleAroundBlockPacket> TYPE = Message.makeType(
            Moonlight.res("s2c_particle"), ClientBoundParticleAroundBlockPacket::new);

    public final Kind type;
    public final class_2338 pos;

    public ClientBoundParticleAroundBlockPacket(class_9129 buffer) {
        this.type = buffer.method_10818(Kind.class);
        this.pos = buffer.method_10811();
    }

    public ClientBoundParticleAroundBlockPacket(class_2338 pos, Kind type) {
        this.pos = pos;
        this.type = type;
    }

    @Override
    public void write(class_9129 buffer) {
        buffer.method_10817(this.type);
        buffer.method_10807(this.pos);
    }

    @Override
    public void handle(Context context) {
        handleSpawnBlockParticlePacket(this);
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE.comp_2243();
    }

    public enum Kind {
        WAX_ON,
        GLOW_ON
    }

    @Environment(EnvType.CLIENT)
    private static void handleSpawnBlockParticlePacket(ClientBoundParticleAroundBlockPacket message) {
        var l = class_310.method_1551().field_1687;

        switch (message.type) {
            case WAX_ON -> {
                ParticleUtil.spawnParticleOnBlockShape(l, message.pos,
                        class_2398.field_29642,
                        class_6019.method_35017(3, 5), 0.01f);
            }
            case GLOW_ON -> {
                ParticleUtil.spawnParticleOnBlockShape(l, message.pos,
                        class_2398.field_28479,
                        class_6019.method_35017(3, 5), 0);
            }
        }
    }


}
